/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.state.changelog.restore.AggregatingStateChangeApplier;
import org.apache.flink.state.changelog.restore.ChangelogApplierFactory;
import org.apache.flink.state.changelog.restore.KvStateChangeApplier;
import org.apache.flink.state.changelog.restore.ListStateChangeApplier;
import org.apache.flink.state.changelog.restore.MapStateChangeApplier;
import org.apache.flink.state.changelog.restore.PriorityQueueStateChangeApplier;
import org.apache.flink.state.changelog.restore.ReducingStateChangeApplier;
import org.apache.flink.state.changelog.restore.StateChangeApplier;
import org.apache.flink.state.changelog.restore.ValueStateChangeApplier;

class ChangelogApplierFactoryImpl
implements ChangelogApplierFactory {
    public static final ChangelogApplierFactoryImpl INSTANCE = new ChangelogApplierFactoryImpl();

    private ChangelogApplierFactoryImpl() {
    }

    @Override
    public <K, N, UK, UV> KvStateChangeApplier<K, N> forMap(InternalMapState<K, N, UK, UV> map, InternalKeyContext<K> keyContext) {
        return new MapStateChangeApplier<K, N, UK, UV>(map, keyContext);
    }

    @Override
    public <K, N, T> KvStateChangeApplier<K, N> forList(InternalListState<K, N, T> state, InternalKeyContext<K> keyContext) {
        return new ListStateChangeApplier<K, N, T>(keyContext, state);
    }

    @Override
    public <K, N, T> KvStateChangeApplier<K, N> forReducing(InternalReducingState<K, N, T> state, InternalKeyContext<K> keyContext) {
        return new ReducingStateChangeApplier<K, N, T>(keyContext, state);
    }

    @Override
    public <K, N, IN, SV, OUT> KvStateChangeApplier<K, N> forAggregating(InternalAggregatingState<K, N, IN, SV, OUT> state, InternalKeyContext<K> keyContext) {
        return new AggregatingStateChangeApplier<K, N, IN, SV, OUT>(keyContext, state);
    }

    @Override
    public <K, N, T> KvStateChangeApplier<K, N> forValue(InternalValueState<K, N, T> state, InternalKeyContext<K> keyContext) {
        return new ValueStateChangeApplier<K, N, T>(keyContext, state);
    }

    @Override
    public <T> StateChangeApplier forPriorityQueue(KeyGroupedInternalPriorityQueue<T> queue, TypeSerializer<T> serializer) {
        return new PriorityQueueStateChangeApplier<T>(queue, serializer);
    }
}

