/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.StateChangeApplier;

class PriorityQueueStateChangeApplier<T>
implements StateChangeApplier {
    private final KeyGroupedInternalPriorityQueue<T> queue;
    private final TypeSerializer<T> serializer;

    public PriorityQueueStateChangeApplier(KeyGroupedInternalPriorityQueue<T> queue, TypeSerializer<T> serializer) {
        this.queue = queue;
        this.serializer = serializer;
    }

    @Override
    public void apply(StateChangeOperation operation, DataInputView in) throws Exception {
        switch (operation) {
            case ADD_ELEMENT: {
                int numElements = in.readInt();
                for (int i = 0; i < numElements; ++i) {
                    this.queue.add(this.serializer.deserialize(in));
                }
                break;
            }
            case REMOVE_ELEMENT: {
                this.queue.remove(this.serializer.deserialize(in));
                break;
            }
            default: {
                throw new UnsupportedOperationException(operation.name());
            }
        }
    }
}

