/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.KvStateChangeApplier;

class MapStateChangeApplier<K, N, UK, UV>
extends KvStateChangeApplier<K, N> {
    private final InternalMapState<K, N, UK, UV> mapState;
    private final MapSerializer<UK, UV> mapSerializer;

    protected MapStateChangeApplier(InternalMapState<K, N, UK, UV> mapState, InternalKeyContext<K> keyContext) {
        super(keyContext);
        this.mapState = mapState;
        this.mapSerializer = (MapSerializer)mapState.getValueSerializer();
    }

    @Override
    protected InternalKvState<K, N, ?> getState() {
        return this.mapState;
    }

    @Override
    protected void applyInternal(StateChangeOperation operation, DataInputView in) throws Exception {
        switch (operation) {
            case ADD: {
                this.mapState.putAll(this.mapSerializer.deserialize(in));
                break;
            }
            case ADD_ELEMENT: 
            case ADD_OR_UPDATE_ELEMENT: {
                this.mapState.put(this.mapSerializer.getKeySerializer().deserialize(in), this.mapSerializer.getValueSerializer().deserialize(in));
                break;
            }
            case REMOVE_ELEMENT: {
                this.mapState.remove(this.mapSerializer.getKeySerializer().deserialize(in));
                break;
            }
            case CLEAR: {
                this.mapState.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state change operation: " + (Object)((Object)operation));
            }
        }
    }
}

