/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.changelog.StateChangelogWriter;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.apache.flink.state.changelog.StateChangeLogger;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

abstract class AbstractStateChangeLogger<Key, Value, Ns>
implements StateChangeLogger<Value, Ns> {
    static final int COMMON_KEY_GROUP = -1;
    protected final StateChangelogWriter<?> stateChangelogWriter;
    protected final InternalKeyContext<Key> keyContext;
    protected final RegisteredStateMetaInfoBase metaInfo;
    private final StateMetaInfoSnapshot.BackendStateType stateType;
    private boolean metaDataWritten = false;

    public AbstractStateChangeLogger(StateChangelogWriter<?> stateChangelogWriter, InternalKeyContext<Key> keyContext, RegisteredStateMetaInfoBase metaInfo) {
        this.stateChangelogWriter = (StateChangelogWriter)Preconditions.checkNotNull(stateChangelogWriter);
        this.keyContext = (InternalKeyContext)Preconditions.checkNotNull(keyContext);
        this.metaInfo = (RegisteredStateMetaInfoBase)Preconditions.checkNotNull((Object)metaInfo);
        if (metaInfo instanceof RegisteredKeyValueStateBackendMetaInfo) {
            this.stateType = StateMetaInfoSnapshot.BackendStateType.KEY_VALUE;
        } else if (metaInfo instanceof RegisteredPriorityQueueStateBackendMetaInfo) {
            this.stateType = StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE;
        } else {
            throw new IllegalArgumentException("Unsupported state type: " + metaInfo);
        }
    }

    @Override
    public void valueUpdated(Value newValue, Ns ns) throws IOException {
        if (newValue == null) {
            this.valueCleared(ns);
        } else {
            this.log(StateChangeOperation.SET, (ThrowingConsumer<DataOutputViewStreamWrapper, IOException>)((ThrowingConsumer)out -> this.serializeValue(newValue, (DataOutputViewStreamWrapper)out)), ns);
        }
    }

    @Override
    public void valueUpdatedInternal(Value newValue, Ns ns) throws IOException {
        if (newValue == null) {
            this.valueCleared(ns);
        } else {
            this.log(StateChangeOperation.SET_INTERNAL, (ThrowingConsumer<DataOutputViewStreamWrapper, IOException>)((ThrowingConsumer)out -> this.serializeValue(newValue, (DataOutputViewStreamWrapper)out)), ns);
        }
    }

    protected abstract void serializeValue(Value var1, DataOutputViewStreamWrapper var2) throws IOException;

    @Override
    public void valueAdded(Value addedValue, Ns ns) throws IOException {
        this.log(StateChangeOperation.ADD, (ThrowingConsumer<DataOutputViewStreamWrapper, IOException>)((ThrowingConsumer)out -> this.serializeValue(addedValue, (DataOutputViewStreamWrapper)out)), ns);
    }

    @Override
    public void valueCleared(Ns ns) throws IOException {
        this.log(StateChangeOperation.CLEAR, ns);
    }

    @Override
    public void valueElementAdded(ThrowingConsumer<DataOutputViewStreamWrapper, IOException> dataSerializer, Ns ns) throws IOException {
        this.log(StateChangeOperation.ADD_ELEMENT, dataSerializer, ns);
    }

    @Override
    public void valueElementAddedOrUpdated(ThrowingConsumer<DataOutputViewStreamWrapper, IOException> dataSerializer, Ns ns) throws IOException {
        this.log(StateChangeOperation.ADD_OR_UPDATE_ELEMENT, dataSerializer, ns);
    }

    @Override
    public void valueElementRemoved(ThrowingConsumer<DataOutputViewStreamWrapper, IOException> dataSerializer, Ns ns) throws IOException {
        this.log(StateChangeOperation.REMOVE_ELEMENT, dataSerializer, ns);
    }

    protected void log(StateChangeOperation op, Ns ns) throws IOException {
        this.logMetaIfNeeded();
        this.stateChangelogWriter.append(this.keyContext.getCurrentKeyGroupIndex(), this.serialize(op, ns, null));
    }

    protected void log(StateChangeOperation op, @Nullable ThrowingConsumer<DataOutputViewStreamWrapper, IOException> dataWriter, Ns ns) throws IOException {
        this.logMetaIfNeeded();
        this.stateChangelogWriter.append(this.keyContext.getCurrentKeyGroupIndex(), this.serialize(op, ns, dataWriter));
    }

    private void logMetaIfNeeded() throws IOException {
        if (!this.metaDataWritten) {
            this.stateChangelogWriter.append(-1, this.serializeRaw((ThrowingConsumer<DataOutputViewStreamWrapper, IOException>)((ThrowingConsumer)out -> {
                out.writeByte((int)StateChangeOperation.METADATA.getCode());
                out.writeInt(6);
                StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(this.metaInfo.snapshot(), (DataOutputView)out);
                this.writeDefaultValueAndTtl((DataOutputViewStreamWrapper)out);
            })));
            this.metaDataWritten = true;
        }
    }

    protected void writeDefaultValueAndTtl(DataOutputViewStreamWrapper out) throws IOException {
    }

    private byte[] serialize(StateChangeOperation op, Ns ns, @Nullable ThrowingConsumer<DataOutputViewStreamWrapper, IOException> dataWriter) throws IOException {
        return this.serializeRaw((ThrowingConsumer<DataOutputViewStreamWrapper, IOException>)((ThrowingConsumer)wrapper -> {
            wrapper.writeByte((int)op.getCode());
            wrapper.writeUTF(this.metaInfo.getName());
            wrapper.writeByte((int)this.stateType.getCode());
            this.serializeScope(ns, (DataOutputViewStreamWrapper)wrapper);
            if (dataWriter != null) {
                dataWriter.accept(wrapper);
            }
        }));
    }

    protected abstract void serializeScope(Ns var1, DataOutputViewStreamWrapper var2) throws IOException;

    /*
     * Exception decompiling
     */
    private byte[] serializeRaw(ThrowingConsumer<DataOutputViewStreamWrapper, IOException> dataWriter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

