/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class CustomIntSerializer
extends TypeSerializerSingleton<Integer> {
    static final TypeSerializer<Integer> INSTANCE = new CustomIntSerializer();
    private static final int MAGIC_VALUE = 2748;

    public boolean isImmutableType() {
        return true;
    }

    public Integer createInstance() {
        return 0;
    }

    public Integer copy(Integer from) {
        return from;
    }

    public Integer copy(Integer from, Integer reuse) {
        return from;
    }

    public int getLength() {
        return 8;
    }

    public void serialize(Integer record, DataOutputView target) throws IOException {
        target.writeInt(2748);
        target.writeInt(record.intValue());
    }

    public Integer deserialize(DataInputView source) throws IOException {
        int header = source.readInt();
        if (header != 2748) {
            throw new RuntimeException(String.format("Invalid magic value, expected %d found %d", 2748, header));
        }
        return source.readInt();
    }

    public Integer deserialize(Integer reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
        return new CustomSerializerSnapshot();
    }

    public static final class CustomSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Integer> {
        public CustomSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

