/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.mock.MockStateBackend;
import org.apache.flink.state.api.input.MultiStateKeyIterator;
import org.junit.Assert;
import org.junit.Test;

public class MultiStateKeyIteratorTest {
    private static final List<ValueStateDescriptor<Integer>> descriptors = new ArrayList<ValueStateDescriptor<Integer>>(2);

    private static AbstractKeyedStateBackend<Integer> createKeyedStateBackend() {
        MockStateBackend backend = new MockStateBackend();
        return backend.createKeyedStateBackend((Environment)new DummyEnvironment(), new JobID(), "mock-backend", (TypeSerializer)IntSerializer.INSTANCE, 129, KeyGroupRange.of((int)0, (int)128), null, TtlTimeProvider.DEFAULT, (MetricGroup)UnregisteredMetricGroups.createUnregisteredTaskMetricGroup(), Collections.emptyList(), new CloseableRegistry());
    }

    private static void setKey(AbstractKeyedStateBackend<Integer> backend, ValueStateDescriptor<Integer> descriptor, int key) throws Exception {
        backend.setCurrentKey((Object)key);
        ((ValueState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, descriptor)).update((Object)0);
    }

    @Test
    public void testIteratorPullsKeyFromAllDescriptors() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedStateBackend = MultiStateKeyIteratorTest.createKeyedStateBackend();
        MultiStateKeyIteratorTest.setKey(keyedStateBackend, descriptors.get(0), 1);
        MultiStateKeyIteratorTest.setKey(keyedStateBackend, descriptors.get(1), 2);
        MultiStateKeyIterator iterator = new MultiStateKeyIterator(descriptors, keyedStateBackend);
        ArrayList<Object> keys = new ArrayList<Object>();
        while (iterator.hasNext()) {
            keys.add(iterator.next());
        }
        Assert.assertEquals((String)"Unexpected number of keys", (long)2L, (long)keys.size());
        Assert.assertEquals((String)"Unexpected keys found", Arrays.asList(1, 2), keys);
    }

    @Test
    public void testIteratorRemovesFromAllDescriptors() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedStateBackend = MultiStateKeyIteratorTest.createKeyedStateBackend();
        MultiStateKeyIteratorTest.setKey(keyedStateBackend, descriptors.get(0), 1);
        MultiStateKeyIteratorTest.setKey(keyedStateBackend, descriptors.get(1), 1);
        MultiStateKeyIterator iterator = new MultiStateKeyIterator(descriptors, keyedStateBackend);
        int key = (Integer)iterator.next();
        Assert.assertEquals((String)"Unexpected keys pulled from state backend", (long)1L, (long)key);
        iterator.remove();
        Assert.assertFalse((String)"Failed to drop key from all descriptors in state backend", (boolean)iterator.hasNext());
        for (StateDescriptor stateDescriptor : descriptors) {
            Assert.assertEquals((String)"Failed to drop key for state descriptor", (long)0L, (long)keyedStateBackend.getKeys(stateDescriptor.getName(), (Object)VoidNamespace.INSTANCE).count());
        }
    }

    static {
        descriptors.add((ValueStateDescriptor<Integer>)new ValueStateDescriptor("state-1", Types.INT));
        descriptors.add((ValueStateDescriptor<Integer>)new ValueStateDescriptor("state-2", Types.INT));
    }
}

