/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input.operator;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.state.api.runtime.SavepointRuntimeContext;
import org.apache.flink.state.api.runtime.VoidTriggerable;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimerSerializer;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StateReaderOperator<F extends Function, KEY, N, OUT>
implements KeyContext,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final F function;
    private final TypeInformation<KEY> keyType;
    protected final TypeSerializer<N> namespaceSerializer;
    private transient ExecutionConfig executionConfig;
    private transient KeyedStateBackend<KEY> keyedStateBackend;
    private transient TypeSerializer<KEY> keySerializer;
    private transient InternalTimeServiceManager<KEY> timerServiceManager;

    protected StateReaderOperator(F function, TypeInformation<KEY> keyType, TypeSerializer<N> namespaceSerializer) {
        Preconditions.checkNotNull(function, (String)"The user function must not be null");
        Preconditions.checkNotNull(keyType, (String)"The key type must not be null");
        Preconditions.checkNotNull(namespaceSerializer, (String)"The namespace serializer must not be null");
        this.function = function;
        this.keyType = keyType;
        this.namespaceSerializer = namespaceSerializer;
    }

    public abstract void processElement(KEY var1, N var2, Collector<OUT> var3) throws Exception;

    public abstract Iterator<Tuple2<KEY, N>> getKeysAndNamespaces(SavepointRuntimeContext var1) throws Exception;

    public final void setup(ExecutionConfig executionConfig, KeyedStateBackend<KEY> keyKeyedStateBackend, InternalTimeServiceManager<KEY> timerServiceManager, SavepointRuntimeContext ctx) {
        this.executionConfig = executionConfig;
        this.keyedStateBackend = keyKeyedStateBackend;
        this.timerServiceManager = timerServiceManager;
        this.keySerializer = this.keyType.createSerializer(executionConfig);
        FunctionUtils.setFunctionRuntimeContext(this.function, (RuntimeContext)ctx);
    }

    protected final InternalTimerService<N> getInternalTimerService(String name) {
        TimerSerializer timerSerializer = new TimerSerializer(this.keySerializer, this.namespaceSerializer);
        return this.timerServiceManager.getInternalTimerService(name, timerSerializer, VoidTriggerable.instance());
    }

    public void open() throws Exception {
        FunctionUtils.openFunction(this.function, (Configuration)new Configuration());
    }

    public void close() throws Exception {
        Exception exception = null;
        try {
            FunctionUtils.closeFunction(this.function);
        }
        catch (Exception e) {
            exception = e;
        }
        this.keyedStateBackend.dispose();
        if (exception != null) {
            throw exception;
        }
    }

    public final void setCurrentKey(Object key) {
        this.keyedStateBackend.setCurrentKey(key);
    }

    public final Object getCurrentKey() {
        return this.keyedStateBackend.getCurrentKey();
    }

    public final KeyedStateBackend<KEY> getKeyedStateBackend() {
        return this.keyedStateBackend;
    }

    public final TypeInformation<KEY> getKeyType() {
        return this.keyType;
    }

    public final ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }
}

