/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public final class MultiStateKeyIterator<K>
implements Iterator<K> {
    private final List<? extends StateDescriptor<?, ?>> descriptors;
    private final KeyedStateBackend<K> backend;
    private final Iterator<K> internal;
    private K currentKey;

    public MultiStateKeyIterator(List<? extends StateDescriptor<?, ?>> descriptors, KeyedStateBackend<K> backend) {
        this.descriptors = (List)Preconditions.checkNotNull(descriptors);
        this.backend = (KeyedStateBackend)Preconditions.checkNotNull(backend);
        this.internal = descriptors.stream().flatMap(descriptor -> backend.getKeys(descriptor.getName(), (Object)VoidNamespace.INSTANCE)).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.internal.hasNext();
    }

    @Override
    public K next() {
        this.currentKey = this.internal.next();
        return this.currentKey;
    }

    @Override
    public void remove() {
        if (this.currentKey == null) {
            return;
        }
        for (StateDescriptor<?, ?> descriptor : this.descriptors) {
            try {
                State state = this.backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, descriptor);
                state.clear();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to drop partitioned state from state backend", e);
            }
        }
    }
}

