/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.WritableSavepoint;
import org.apache.flink.state.api.functions.KeyedStateReaderFunction;
import org.apache.flink.state.api.input.BroadcastStateInputFormat;
import org.apache.flink.state.api.input.KeyedStateInputFormat;
import org.apache.flink.state.api.input.ListStateInputFormat;
import org.apache.flink.state.api.input.UnionStateInputFormat;
import org.apache.flink.state.api.input.operator.KeyedStateReaderOperator;
import org.apache.flink.state.api.runtime.metadata.SavepointMetadata;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ExistingSavepoint
extends WritableSavepoint<ExistingSavepoint> {
    private final ExecutionEnvironment env;
    private final SavepointMetadata metadata;
    private final StateBackend stateBackend;

    ExistingSavepoint(ExecutionEnvironment env, SavepointMetadata metadata, StateBackend stateBackend) throws IOException {
        super(metadata, stateBackend);
        Preconditions.checkNotNull((Object)env, (String)"The execution environment must not be null");
        Preconditions.checkNotNull((Object)metadata, (String)"The savepoint metadata must not be null");
        Preconditions.checkNotNull((Object)stateBackend, (String)"The state backend must not be null");
        this.env = env;
        this.metadata = metadata;
        this.stateBackend = stateBackend;
    }

    public <T> DataSet<T> readListState(String uid, String name, TypeInformation<T> typeInfo) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        ListStateDescriptor descriptor = new ListStateDescriptor(name, typeInfo);
        ListStateInputFormat inputFormat = new ListStateInputFormat(operatorState, descriptor);
        return this.env.createInput(inputFormat, typeInfo);
    }

    public <T> DataSet<T> readListState(String uid, String name, TypeInformation<T> typeInfo, TypeSerializer<T> serializer) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        ListStateDescriptor descriptor = new ListStateDescriptor(name, serializer);
        ListStateInputFormat inputFormat = new ListStateInputFormat(operatorState, descriptor);
        return this.env.createInput(inputFormat, typeInfo);
    }

    public <T> DataSet<T> readUnionState(String uid, String name, TypeInformation<T> typeInfo) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        ListStateDescriptor descriptor = new ListStateDescriptor(name, typeInfo);
        UnionStateInputFormat inputFormat = new UnionStateInputFormat(operatorState, descriptor);
        return this.env.createInput(inputFormat, typeInfo);
    }

    public <T> DataSet<T> readUnionState(String uid, String name, TypeInformation<T> typeInfo, TypeSerializer<T> serializer) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        ListStateDescriptor descriptor = new ListStateDescriptor(name, serializer);
        UnionStateInputFormat inputFormat = new UnionStateInputFormat(operatorState, descriptor);
        return this.env.createInput(inputFormat, typeInfo);
    }

    public <K, V> DataSet<Tuple2<K, V>> readBroadcastState(String uid, String name, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        MapStateDescriptor descriptor = new MapStateDescriptor(name, keyTypeInfo, valueTypeInfo);
        BroadcastStateInputFormat inputFormat = new BroadcastStateInputFormat(operatorState, descriptor);
        return this.env.createInput(inputFormat, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{keyTypeInfo, valueTypeInfo}));
    }

    public <K, V> DataSet<Tuple2<K, V>> readBroadcastState(String uid, String name, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        MapStateDescriptor descriptor = new MapStateDescriptor(name, keySerializer, valueSerializer);
        BroadcastStateInputFormat inputFormat = new BroadcastStateInputFormat(operatorState, descriptor);
        return this.env.createInput(inputFormat, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{keyTypeInfo, valueTypeInfo}));
    }

    public <K, OUT> DataSet<OUT> readKeyedState(String uid, KeyedStateReaderFunction<K, OUT> function) throws IOException {
        TypeInformation outType;
        TypeInformation keyTypeInfo;
        try {
            keyTypeInfo = TypeExtractor.createTypeInfo(KeyedStateReaderFunction.class, ((Object)function).getClass(), (int)0, null, null);
        }
        catch (InvalidTypesException e) {
            throw new InvalidProgramException("The key type of the KeyedStateReaderFunction could not be automatically determined. Please use Savepoint#readKeyedState(String, KeyedStateReaderFunction, TypeInformation, TypeInformation) instead.", (Throwable)e);
        }
        try {
            outType = TypeExtractor.getUnaryOperatorReturnType(function, KeyedStateReaderFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, (TypeInformation)keyTypeInfo, (String)Utils.getCallLocationName(), (boolean)false);
        }
        catch (InvalidTypesException e) {
            throw new InvalidProgramException("The output type of the KeyedStateReaderFunction could not be automatically determined. Please use Savepoint#readKeyedState(String, KeyedStateReaderFunction, TypeInformation, TypeInformation) instead.", (Throwable)e);
        }
        return this.readKeyedState(uid, function, keyTypeInfo, outType);
    }

    public <K, OUT> DataSet<OUT> readKeyedState(String uid, KeyedStateReaderFunction<K, OUT> function, TypeInformation<K> keyTypeInfo, TypeInformation<OUT> outTypeInfo) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(uid);
        KeyedStateInputFormat inputFormat = new KeyedStateInputFormat(operatorState, this.stateBackend, this.env.getConfiguration(), new KeyedStateReaderOperator<K, OUT>(function, keyTypeInfo));
        return this.env.createInput(inputFormat, outTypeInfo);
    }
}

