/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.state.api.output.SnapshotUtils;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.state.api.runtime.NeverFireProcessingTimeService;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.SetupableStreamOperator;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.OutputTag;

@Internal
public final class StateBootstrapWrapperOperator<IN, OUT, OP extends AbstractStreamOperator<OUT>>
implements OneInputStreamOperator<IN, TaggedOperatorSubtaskState>,
SetupableStreamOperator<TaggedOperatorSubtaskState>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final Path savepointPath;
    private Output<StreamRecord<TaggedOperatorSubtaskState>> output;
    private final OP operator;

    public StateBootstrapWrapperOperator(long timestamp, Path savepointPath, OP operator) {
        this.timestamp = timestamp;
        this.savepointPath = savepointPath;
        this.operator = operator;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<TaggedOperatorSubtaskState>> output) {
        this.operator.setup(containingTask, config, new VoidOutput());
        this.operator.setProcessingTimeService((ProcessingTimeService)new NeverFireProcessingTimeService());
        this.output = output;
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        ((Input)this.operator).processElement(element);
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.operator.processWatermark(mark);
    }

    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        this.operator.processLatencyMarker(latencyMarker);
    }

    public void open() throws Exception {
        this.operator.open();
    }

    public void close() throws Exception {
        this.operator.close();
    }

    public void dispose() throws Exception {
        this.operator.dispose();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.operator.prepareSnapshotPreBarrier(checkpointId);
    }

    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation) throws Exception {
        return this.operator.snapshotState(checkpointId, timestamp, checkpointOptions, storageLocation);
    }

    public void initializeState(StreamTaskStateInitializer streamTaskStateManager) throws Exception {
        this.operator.initializeState(streamTaskStateManager);
    }

    public void setKeyContextElement1(StreamRecord<?> record) throws Exception {
        this.operator.setKeyContextElement1(record);
    }

    public void setKeyContextElement2(StreamRecord<?> record) throws Exception {
        this.operator.setKeyContextElement2(record);
    }

    public ChainingStrategy getChainingStrategy() {
        return this.operator.getChainingStrategy();
    }

    public void setChainingStrategy(ChainingStrategy strategy) {
        this.operator.setChainingStrategy(strategy);
    }

    public MetricGroup getMetricGroup() {
        return this.operator.getMetricGroup();
    }

    public OperatorID getOperatorID() {
        return this.operator.getOperatorID();
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.operator.notifyCheckpointComplete(checkpointId);
    }

    public void setCurrentKey(Object key) {
        this.operator.setCurrentKey(key);
    }

    public Object getCurrentKey() {
        return this.operator.getCurrentKey();
    }

    public void endInput() throws Exception {
        TaggedOperatorSubtaskState state = SnapshotUtils.snapshot(this, this.operator.getContainingTask().getEnvironment().getTaskInfo().getIndexOfThisSubtask(), this.timestamp, this.operator.getContainingTask().getConfiguration().isExactlyOnceCheckpointMode(), this.operator.getContainingTask().getConfiguration().isUnalignedCheckpointsEnabled(), this.operator.getContainingTask().getCheckpointStorage(), this.savepointPath);
        this.output.collect((Object)new StreamRecord((Object)state));
    }

    private static class VoidOutput<T>
    implements Output<T> {
        private VoidOutput() {
        }

        public void emitWatermark(Watermark mark) {
        }

        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        }

        public void emitLatencyMarker(LatencyMarker latencyMarker) {
        }

        public void collect(T record) {
        }

        public void close() {
        }
    }
}

