/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.util.Collector;

@Internal
public class StatePathExtractor
implements FlatMapFunction<OperatorState, String> {
    private static final long serialVersionUID = 1L;

    public void flatMap(OperatorState operatorState, Collector<String> out) throws Exception {
        for (OperatorSubtaskState subTaskState : operatorState.getSubtaskStates().values()) {
            Path path;
            for (OperatorStateHandle operatorStateHandle : subTaskState.getManagedOperatorState()) {
                path = this.getStateFilePathFromStreamStateHandle((StreamStateHandle)operatorStateHandle);
                if (path == null) continue;
                out.collect((Object)path.getPath());
            }
            for (KeyedStateHandle keyedStateHandle : subTaskState.getManagedKeyedState()) {
                if (!(keyedStateHandle instanceof KeyGroupsStateHandle) || (path = this.getStateFilePathFromStreamStateHandle((StreamStateHandle)((KeyGroupsStateHandle)keyedStateHandle))) == null) continue;
                out.collect((Object)path.getPath());
            }
            for (OperatorStateHandle operatorStateHandle : subTaskState.getRawOperatorState()) {
                path = this.getStateFilePathFromStreamStateHandle((StreamStateHandle)operatorStateHandle);
                if (path == null) continue;
                out.collect((Object)path.getPath());
            }
            for (KeyedStateHandle keyedStateHandle : subTaskState.getRawKeyedState()) {
                if (!(keyedStateHandle instanceof KeyGroupsStateHandle) || (path = this.getStateFilePathFromStreamStateHandle((StreamStateHandle)((KeyGroupsStateHandle)keyedStateHandle))) == null) continue;
                out.collect((Object)path.getPath());
            }
        }
    }

    @Nullable
    private Path getStateFilePathFromStreamStateHandle(StreamStateHandle handle) {
        if (handle instanceof FileStateHandle) {
            return ((FileStateHandle)handle).getFilePath();
        }
        if (handle instanceof OperatorStateHandle) {
            return this.getStateFilePathFromStreamStateHandle(((OperatorStateHandle)handle).getDelegateStateHandle());
        }
        if (handle instanceof KeyedStateHandle && handle instanceof KeyGroupsStateHandle) {
            return this.getStateFilePathFromStreamStateHandle(((KeyGroupsStateHandle)handle).getDelegateStateHandle());
        }
        return null;
    }
}

