/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFinalizer;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.StreamOperator;

@Internal
public final class SnapshotUtils {
    static final long CHECKPOINT_ID = 0L;

    private SnapshotUtils() {
    }

    public static <OUT, OP extends StreamOperator<OUT>> TaggedOperatorSubtaskState snapshot(OP operator, int index, long timestamp, boolean isExactlyOnceMode, boolean isUnalignedCheckpoint, CheckpointStorageWorkerView checkpointStorage, Path savepointPath) throws Exception {
        CheckpointOptions options = CheckpointOptions.forConfig((CheckpointType)CheckpointType.SAVEPOINT, (CheckpointStorageLocationReference)AbstractFsCheckpointStorageAccess.encodePathAsReference((Path)savepointPath), (boolean)isExactlyOnceMode, (boolean)isUnalignedCheckpoint, (long)Long.MAX_VALUE);
        operator.prepareSnapshotPreBarrier(0L);
        CheckpointStreamFactory storage = checkpointStorage.resolveCheckpointStorageLocation(0L, options.getTargetLocation());
        OperatorSnapshotFutures snapshotInProgress = operator.snapshotState(0L, timestamp, options, storage);
        OperatorSubtaskState state = new OperatorSnapshotFinalizer(snapshotInProgress).getJobManagerOwnedState();
        operator.notifyCheckpointComplete(0L);
        return new TaggedOperatorSubtaskState(index, state);
    }
}

