/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class FileCopyFunction
implements OutputFormat<String> {
    private static final long serialVersionUID = 1L;
    private final String path;

    public FileCopyFunction(String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (String)"The destination path cannot be null");
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        Path destParent = new Path(this.path);
        destParent.getFileSystem().mkdirs(destParent);
    }

    public void writeRecord(String record) throws IOException {
        Path sourcePath = new Path(record);
        Path destPath = new Path(this.path, sourcePath.getName());
        try (FSDataOutputStream os = destPath.getFileSystem().create(destPath, FileSystem.WriteMode.NO_OVERWRITE);
             FSDataInputStream is = sourcePath.getFileSystem().open(sourcePath);){
            IOUtils.copyBytes((InputStream)is, (OutputStream)os);
        }
    }

    public void configure(Configuration parameters) {
    }

    public void close() throws IOException {
    }
}

