/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.Iterator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.state.api.functions.Timestamper;
import org.apache.flink.state.api.runtime.NeverFireProcessingTimeService;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactoryUtil;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

class BoundedStreamTask<IN, OUT, OP extends OneInputStreamOperator<IN, OUT> & BoundedOneInput>
extends StreamTask<OUT, OP> {
    private final Iterator<IN> input;
    private final Collector<OUT> collector;
    private final Timestamper<IN> timestamper;

    BoundedStreamTask(Environment environment, Iterable<IN> input, Timestamper<IN> timestamper, Collector<OUT> collector) throws Exception {
        super(environment, (TimerService)new NeverFireProcessingTimeService());
        this.input = input.iterator();
        this.collector = collector;
        this.timestamper = timestamper;
    }

    protected void init() throws Exception {
        Preconditions.checkState((this.operatorChain.getNumberOfOperators() == 1 ? 1 : 0) != 0, (Object)"BoundedStreamTask's should only run a single operator");
        StreamOperatorFactory operatorFactory = this.configuration.getStreamOperatorFactory(this.getUserCodeClassLoader());
        Tuple2 mainOperatorAndTimeService = StreamOperatorFactoryUtil.createOperator((StreamOperatorFactory)operatorFactory, (StreamTask)this, (StreamConfig)this.configuration, new CollectorWrapper(this.collector), (OperatorEventDispatcher)this.operatorChain.getOperatorEventDispatcher());
        this.mainOperator = (StreamOperator)mainOperatorAndTimeService.f0;
        ((OneInputStreamOperator)this.mainOperator).initializeState(this.createStreamTaskStateInitializer());
        ((OneInputStreamOperator)this.mainOperator).open();
    }

    protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
        if (this.input.hasNext()) {
            StreamRecord streamRecord = new StreamRecord(this.input.next());
            if (this.timestamper != null) {
                long timestamp = this.timestamper.timestamp(streamRecord.getValue());
                streamRecord.setTimestamp(timestamp);
            }
            ((OneInputStreamOperator)this.mainOperator).setKeyContextElement1(streamRecord);
            ((OneInputStreamOperator)this.mainOperator).processElement(streamRecord);
        } else {
            ((BoundedOneInput)((OneInputStreamOperator)this.mainOperator)).endInput();
            controller.allActionsCompleted();
        }
    }

    protected void cancelTask() {
    }

    protected void cleanup() throws Exception {
        ((OneInputStreamOperator)this.mainOperator).close();
        ((OneInputStreamOperator)this.mainOperator).dispose();
    }

    private static class CollectorWrapper<OUT>
    implements Output<StreamRecord<OUT>> {
        private final Collector<OUT> inner;

        private CollectorWrapper(Collector<OUT> inner) {
            this.inner = inner;
        }

        public void emitWatermark(Watermark mark) {
        }

        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        }

        public void emitLatencyMarker(LatencyMarker latencyMarker) {
        }

        public void collect(StreamRecord<OUT> record) {
            this.inner.collect(record.getValue());
        }

        public void close() {
        }
    }
}

