/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.state.api.functions.Timestamper;
import org.apache.flink.state.api.output.BoundedStreamTask;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.state.api.runtime.SavepointEnvironment;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.util.Collector;

@Internal
public class BoundedOneInputStreamTaskRunner<IN>
extends RichMapPartitionFunction<IN, TaggedOperatorSubtaskState> {
    private static final long serialVersionUID = 1L;
    private final StreamConfig streamConfig;
    private final int maxParallelism;
    private final Timestamper<IN> timestamper;
    private transient SavepointEnvironment env;

    public BoundedOneInputStreamTaskRunner(StreamConfig streamConfig, int maxParallelism, Timestamper<IN> timestamper) {
        this.streamConfig = streamConfig;
        this.maxParallelism = maxParallelism;
        this.timestamper = timestamper;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.env = new SavepointEnvironment.Builder(this.getRuntimeContext(), this.maxParallelism).setConfiguration(this.streamConfig.getConfiguration()).build();
    }

    public void mapPartition(Iterable<IN> values, Collector<TaggedOperatorSubtaskState> out) throws Exception {
        new BoundedStreamTask(this.env, values, this.timestamper, out).invoke();
    }
}

