/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.state.api.BootstrapTransformation;
import org.apache.flink.state.api.KeyedOperatorTransformation;
import org.apache.flink.state.api.SavepointWriterOperatorFactory;
import org.apache.flink.state.api.functions.BroadcastStateBootstrapFunction;
import org.apache.flink.state.api.functions.StateBootstrapFunction;
import org.apache.flink.state.api.functions.Timestamper;
import org.apache.flink.state.api.output.TimestampAssignerWrapper;
import org.apache.flink.state.api.output.operators.BroadcastStateBootstrapOperator;
import org.apache.flink.state.api.output.operators.StateBootstrapOperator;
import org.apache.flink.streaming.api.functions.TimestampAssigner;
import org.apache.flink.streaming.util.keys.KeySelectorUtil;

@PublicEvolving
public class OneInputOperatorTransformation<T> {
    private final DataSet<T> dataSet;
    private OptionalInt operatorMaxParallelism = OptionalInt.empty();
    @Nullable
    private Timestamper<T> timestamper;

    OneInputOperatorTransformation(DataSet<T> dataSet) {
        this.dataSet = dataSet;
    }

    @PublicEvolving
    public OneInputOperatorTransformation<T> setMaxParallelism(int maxParallelism) {
        this.operatorMaxParallelism = OptionalInt.of(maxParallelism);
        return this;
    }

    public OneInputOperatorTransformation<T> assignTimestamps(Timestamper<T> timestamper) {
        this.timestamper = timestamper;
        return this;
    }

    public OneInputOperatorTransformation<T> assignTimestamps(TimestampAssigner<T> assigner) {
        this.timestamper = new TimestampAssignerWrapper<T>(assigner);
        return this;
    }

    public BootstrapTransformation<T> transform(StateBootstrapFunction<T> processFunction) {
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new StateBootstrapOperator(timestamp, path, processFunction);
        return this.transform(factory);
    }

    public BootstrapTransformation<T> transform(BroadcastStateBootstrapFunction<T> processFunction) {
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new BroadcastStateBootstrapOperator(timestamp, path, processFunction);
        return this.transform(factory);
    }

    public BootstrapTransformation<T> transform(SavepointWriterOperatorFactory factory) {
        return new BootstrapTransformation<T>(this.dataSet, this.operatorMaxParallelism, this.timestamper, factory);
    }

    public <K> KeyedOperatorTransformation<K, T> keyBy(KeySelector<T, K> keySelector) {
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, (TypeInformation)this.dataSet.getType());
        return new KeyedOperatorTransformation<K, T>(this.dataSet, this.operatorMaxParallelism, this.timestamper, keySelector, keyType);
    }

    public <K> KeyedOperatorTransformation<K, T> keyBy(KeySelector<T, K> keySelector, TypeInformation<K> keyType) {
        return new KeyedOperatorTransformation<K, T>(this.dataSet, this.operatorMaxParallelism, this.timestamper, keySelector, keyType);
    }

    public KeyedOperatorTransformation<Tuple, T> keyBy(int ... fields) {
        if (this.dataSet.getType() instanceof BasicArrayTypeInfo || this.dataSet.getType() instanceof PrimitiveArrayTypeInfo) {
            return this.keyBy((KeySelector)KeySelectorUtil.getSelectorForArray((int[])fields, (TypeInformation)this.dataSet.getType()));
        }
        return this.keyBy((Keys<T>)new Keys.ExpressionKeys(fields, this.dataSet.getType()));
    }

    public KeyedOperatorTransformation<Tuple, T> keyBy(String ... fields) {
        return this.keyBy((Keys<T>)new Keys.ExpressionKeys(fields, this.dataSet.getType()));
    }

    private KeyedOperatorTransformation<Tuple, T> keyBy(Keys<T> keys) {
        KeySelector keySelector = KeySelectorUtil.getSelectorForKeys(keys, (TypeInformation)this.dataSet.getType(), (ExecutionConfig)this.dataSet.getExecutionEnvironment().getConfig());
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes((KeySelector)keySelector, (TypeInformation)this.dataSet.getType());
        return new KeyedOperatorTransformation(this.dataSet, this.operatorMaxParallelism, this.timestamper, keySelector, keyType);
    }
}

