/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.state.api.BootstrapTransformation;
import org.apache.flink.state.api.SavepointWriterOperatorFactory;
import org.apache.flink.state.api.WindowedOperatorTransformation;
import org.apache.flink.state.api.functions.KeyedStateBootstrapFunction;
import org.apache.flink.state.api.functions.Timestamper;
import org.apache.flink.state.api.output.operators.KeyedStateBootstrapOperator;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;

@PublicEvolving
public class KeyedOperatorTransformation<K, T> {
    private final DataSet<T> dataSet;
    private final OptionalInt operatorMaxParallelism;
    @Nullable
    private final Timestamper<T> timestamper;
    private final KeySelector<T, K> keySelector;
    private final TypeInformation<K> keyType;

    KeyedOperatorTransformation(DataSet<T> dataSet, OptionalInt operatorMaxParallelism, @Nullable Timestamper<T> timestamper, KeySelector<T, K> keySelector, TypeInformation<K> keyType) {
        this.dataSet = dataSet;
        this.operatorMaxParallelism = operatorMaxParallelism;
        this.timestamper = timestamper;
        this.keySelector = keySelector;
        this.keyType = keyType;
    }

    public BootstrapTransformation<T> transform(KeyedStateBootstrapFunction<K, T> processFunction) {
        SavepointWriterOperatorFactory factory = (timestamp, path) -> new KeyedStateBootstrapOperator(timestamp, path, processFunction);
        return this.transform(factory);
    }

    public BootstrapTransformation<T> transform(SavepointWriterOperatorFactory factory) {
        return new BootstrapTransformation<T>(this.dataSet, this.operatorMaxParallelism, this.timestamper, factory, this.keySelector, this.keyType);
    }

    public <W extends Window> WindowedOperatorTransformation<T, K, W> window(WindowAssigner<? super T, W> assigner) {
        return new WindowedOperatorTransformation<T, K, W>(this.dataSet, this.operatorMaxParallelism, this.timestamper, this.keySelector, this.keyType, assigner);
    }
}

