/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.state.api.input.UnionStateInputFormat;
import org.apache.flink.state.api.input.splits.OperatorStateInputSplit;
import org.apache.flink.state.api.runtime.OperatorIDGenerator;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamFlatMap;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class UnionStateInputFormatTest {
    private static ListStateDescriptor<Integer> descriptor = new ListStateDescriptor("state", Types.INT);

    @Test
    public void testReadUnionOperatorState() throws Exception {
        try (OneInputStreamOperatorTestHarness<Integer, Void> testHarness = this.getTestHarness();){
            testHarness.open();
            testHarness.processElement((Object)1, 0L);
            testHarness.processElement((Object)2, 0L);
            testHarness.processElement((Object)3, 0L);
            OperatorSubtaskState subtaskState = testHarness.snapshot(0L, 0L);
            OperatorState state = new OperatorState(OperatorIDGenerator.fromUid((String)"uid"), 1, 4);
            state.putState(0, subtaskState);
            OperatorStateInputSplit split = new OperatorStateInputSplit(subtaskState.getManagedOperatorState(), 0);
            UnionStateInputFormat format = new UnionStateInputFormat(state, descriptor);
            format.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
            format.open(split);
            ArrayList<Object> results = new ArrayList<Object>();
            while (!format.reachedEnd()) {
                results.add(format.nextRecord((Object)0));
            }
            results.sort(Comparator.naturalOrder());
            Assert.assertEquals((String)"Failed to read correct list state from state backend", Arrays.asList(1, 2, 3), results);
        }
    }

    private OneInputStreamOperatorTestHarness<Integer, Void> getTestHarness() throws Exception {
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamFlatMap((FlatMapFunction)new StatefulFunction()), (TypeSerializer)IntSerializer.INSTANCE);
    }

    static class StatefulFunction
    implements FlatMapFunction<Integer, Void>,
    CheckpointedFunction {
        ListState<Integer> state;

        StatefulFunction() {
        }

        public void flatMap(Integer value, Collector<Void> out) throws Exception {
            this.state.add((Object)value);
        }

        public void snapshotState(FunctionSnapshotContext context) {
        }

        public void initializeState(FunctionInitializationContext context) throws Exception {
            this.state = context.getOperatorStateStore().getUnionListState(descriptor);
        }
    }
}

