/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.StateChangelogOptionsInternal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.PrioritizedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphID;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.state.api.runtime.SavepointTaskManagerRuntimeInfo;
import org.apache.flink.state.api.runtime.SavepointTaskStateManager;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.UserCodeClassLoader;

@Internal
public class SavepointEnvironment
implements Environment {
    private static final String ERROR_MSG = "This method should never be called";
    private final JobID jobID = new JobID();
    private final JobVertexID vertexID = new JobVertexID();
    private final ExecutionAttemptID attemptID;
    private final RuntimeContext ctx;
    private final Configuration configuration;
    private final int maxParallelism;
    private final int indexOfSubtask;
    private final TaskKvStateRegistry registry;
    private final TaskStateManager taskStateManager;
    private final IOManager ioManager;
    private final MemoryManager memoryManager;
    private final SharedResources sharedResources;
    private final AccumulatorRegistry accumulatorRegistry;
    private final UserCodeClassLoader userCodeClassLoader;
    private final ChannelStateWriteRequestExecutorFactory channelStateExecutorFactory;

    private SavepointEnvironment(RuntimeContext ctx, Configuration configuration, int maxParallelism, int indexOfSubtask, PrioritizedOperatorSubtaskState prioritizedOperatorSubtaskState) {
        this.attemptID = new ExecutionAttemptID(new ExecutionGraphID(), new ExecutionVertexID(this.vertexID, indexOfSubtask), 0);
        this.ctx = (RuntimeContext)Preconditions.checkNotNull((Object)ctx);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkArgument((maxParallelism > 0 && indexOfSubtask < maxParallelism ? 1 : 0) != 0);
        this.maxParallelism = maxParallelism;
        this.indexOfSubtask = indexOfSubtask;
        this.registry = new KvStateRegistry().createTaskRegistry(this.jobID, this.vertexID);
        this.taskStateManager = new SavepointTaskStateManager(prioritizedOperatorSubtaskState);
        this.ioManager = new IOManagerAsync(ConfigurationUtils.parseTempDirectories((Configuration)configuration));
        this.memoryManager = MemoryManager.create((long)0x4000000L, (int)32768);
        this.sharedResources = new SharedResources();
        this.accumulatorRegistry = new AccumulatorRegistry(this.jobID, this.attemptID);
        this.userCodeClassLoader = UserCodeClassLoaderRuntimeContextAdapter.from(ctx);
        this.channelStateExecutorFactory = new ChannelStateWriteRequestExecutorFactory(this.jobID);
    }

    public ExecutionConfig getExecutionConfig() {
        return this.ctx.getExecutionConfig();
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public JobVertexID getJobVertexId() {
        return this.vertexID;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.attemptID;
    }

    public Configuration getTaskConfiguration() {
        return this.configuration;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return new SavepointTaskManagerRuntimeInfo(this.getIOManager().getSpillingDirectories()[0]);
    }

    public TaskMetricGroup getMetricGroup() {
        return UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
    }

    public Configuration getJobConfiguration() {
        Configuration jobConfiguration = new Configuration();
        jobConfiguration.setBoolean(StateChangelogOptionsInternal.ENABLE_CHANGE_LOG_FOR_APPLICATION, false);
        return jobConfiguration;
    }

    public TaskInfo getTaskInfo() {
        return new TaskInfo(this.ctx.getTaskName(), this.maxParallelism, this.indexOfSubtask, this.ctx.getNumberOfParallelSubtasks(), this.ctx.getAttemptNumber());
    }

    public InputSplitProvider getInputSplitProvider() {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public GlobalAggregateManager getGlobalAggregateManager() {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public ExternalResourceInfoProvider getExternalResourceInfoProvider() {
        return ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.registry;
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public void declineCheckpoint(long checkpointId, CheckpointException checkpointException) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public TaskOperatorEventGateway getOperatorCoordinatorEventGateway() {
        return new NoOpTaskOperatorEventGateway();
    }

    public void failExternally(Throwable cause) {
        ExceptionUtils.rethrow((Throwable)cause);
    }

    public ResultPartitionWriter getWriter(int index) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return new ResultPartitionWriter[0];
    }

    public IndexedInputGate getInputGate(int index) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public IndexedInputGate[] getAllInputGates() {
        return new IndexedInputGate[0];
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    public ChannelStateWriteRequestExecutorFactory getChannelStateExecutorFactory() {
        return this.channelStateExecutorFactory;
    }

    private static final class NoOpTaskOperatorEventGateway
    implements TaskOperatorEventGateway {
        private NoOpTaskOperatorEventGateway() {
        }

        public void sendOperatorEventToCoordinator(OperatorID operator, SerializedValue<OperatorEvent> event) {
        }

        public CompletableFuture<CoordinationResponse> sendRequestToCoordinator(OperatorID operator, SerializedValue<CoordinationRequest> request) {
            return CompletableFuture.completedFuture(null);
        }
    }

    private static final class UserCodeClassLoaderRuntimeContextAdapter
    implements UserCodeClassLoader {
        private final RuntimeContext runtimeContext;

        private UserCodeClassLoaderRuntimeContextAdapter(RuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
        }

        public ClassLoader asClassLoader() {
            return this.runtimeContext.getUserCodeClassLoader();
        }

        public void registerReleaseHookIfAbsent(String releaseHookName, Runnable releaseHook) {
            this.runtimeContext.registerUserCodeClassLoaderReleaseHookIfAbsent(releaseHookName, releaseHook);
        }

        private static UserCodeClassLoaderRuntimeContextAdapter from(RuntimeContext runtimeContext) {
            return new UserCodeClassLoaderRuntimeContextAdapter(runtimeContext);
        }
    }

    public static class Builder {
        private RuntimeContext ctx;
        private Configuration configuration;
        private int maxParallelism;
        private int indexOfSubtask;
        private PrioritizedOperatorSubtaskState prioritizedOperatorSubtaskState;

        public Builder(RuntimeContext ctx, int maxParallelism) {
            this.ctx = (RuntimeContext)Preconditions.checkNotNull((Object)ctx);
            Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0);
            this.maxParallelism = maxParallelism;
            this.prioritizedOperatorSubtaskState = PrioritizedOperatorSubtaskState.emptyNotRestored();
            this.configuration = new Configuration();
            this.indexOfSubtask = ctx.getIndexOfThisSubtask();
        }

        public Builder setSubtaskIndex(int indexOfSubtask) {
            this.indexOfSubtask = indexOfSubtask;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setPrioritizedOperatorSubtaskState(PrioritizedOperatorSubtaskState prioritizedOperatorSubtaskState) {
            this.prioritizedOperatorSubtaskState = prioritizedOperatorSubtaskState;
            return this;
        }

        public SavepointEnvironment build() {
            return new SavepointEnvironment(this.ctx, this.configuration, this.maxParallelism, this.indexOfSubtask, this.prioritizedOperatorSubtaskState);
        }
    }
}

