/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.input.OperatorStateInputFormat;
import org.apache.flink.util.Preconditions;

@Internal
public class BroadcastStateInputFormat<K, V>
extends OperatorStateInputFormat<Tuple2<K, V>> {
    private static final long serialVersionUID = -7625225340801402409L;
    private final MapStateDescriptor<K, V> descriptor;

    public BroadcastStateInputFormat(OperatorState operatorState, Configuration configuration, @Nullable StateBackend backend, MapStateDescriptor<K, V> descriptor) {
        super(operatorState, configuration, backend, true);
        this.descriptor = (MapStateDescriptor)Preconditions.checkNotNull(descriptor, (String)"The state descriptor must not be null");
    }

    @Override
    protected final Iterable<Tuple2<K, V>> getElements(OperatorStateBackend restoredBackend) throws Exception {
        Iterable entries = restoredBackend.getBroadcastState(this.descriptor).entries();
        return () -> StreamSupport.stream(entries.spliterator(), false).map(entry -> Tuple2.of(entry.getKey(), entry.getValue())).iterator();
    }
}

