/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.core.testutils.OneShotLatch;

public class OperatorLatch
implements Serializable {
    private static final Map<String, OneShotLatch> guards = new ConcurrentHashMap<String, OneShotLatch>();
    private final String guardId = UUID.randomUUID().toString();

    public OperatorLatch() {
        guards.put(this.guardId, new OneShotLatch());
    }

    public void trigger() {
        guards.get(this.guardId).trigger();
    }

    public void await() throws RuntimeException {
        try {
            guards.get(this.guardId).await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to await operator");
        }
    }
}

