/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.Serializable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.state.api.OperatorTransformation;
import org.apache.flink.state.api.SavepointWriter;
import org.apache.flink.state.api.StateBootstrapTransformation;
import org.apache.flink.state.api.functions.KeyedStateBootstrapFunction;
import org.apache.flink.state.api.utils.CustomStateBackendFactory;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.junit.Test;

public class SavepointWriterTest {
    @Test(expected=CustomStateBackendFactory.ExpectedException.class)
    public void testCustomStateBackend() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration configuration = new Configuration();
        configuration.set(StateBackendOptions.STATE_BACKEND, (Object)CustomStateBackendFactory.class.getCanonicalName());
        configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        env.configure((ReadableConfig)configuration);
        DataStreamSource input = env.fromElements((Object[])new String[]{""});
        StateBootstrapTransformation transformation = OperatorTransformation.bootstrapWith((DataStream)input).keyBy((KeySelector & Serializable)element -> element).transform((KeyedStateBootstrapFunction)new Bootstrapper());
        SavepointWriter.newSavepoint((int)128).withOperator("uid", transformation).write("file:///tmp/path");
        env.execute();
    }

    private static class Bootstrapper
    extends KeyedStateBootstrapFunction<String, String> {
        private Bootstrapper() {
        }

        public void processElement(String value, KeyedStateBootstrapFunction.Context ctx) throws Exception {
        }
    }
}

