/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.state.api.BootstrapTransformation;
import org.apache.flink.state.api.ExistingSavepoint;
import org.apache.flink.state.api.NewSavepoint;
import org.apache.flink.state.api.OperatorTransformation;
import org.apache.flink.state.api.functions.StateBootstrapFunction;
import org.apache.flink.state.api.runtime.OperatorIDGenerator;
import org.apache.flink.state.api.runtime.metadata.SavepointMetadata;
import org.junit.Test;

public class SavepointTest {
    private static final String UID = "uid";

    @Test(expected=IllegalArgumentException.class)
    public void testNewSavepointEnforceUniqueUIDs() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(10);
        DataSource input = env.fromElements((Object[])new Integer[]{0});
        BootstrapTransformation transformation = OperatorTransformation.bootstrapWith((DataSet)input).transform((StateBootstrapFunction)new ExampleStateBootstrapFunction());
        SavepointMetadata metadata = new SavepointMetadata(1, Collections.emptyList(), Collections.emptyList());
        ((NewSavepoint)new NewSavepoint(metadata, (StateBackend)new MemoryStateBackend()).withOperator(UID, transformation)).withOperator(UID, transformation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistingSavepointEnforceUniqueUIDs() throws IOException {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(10);
        DataSource input = env.fromElements((Object[])new Integer[]{0});
        BootstrapTransformation transformation = OperatorTransformation.bootstrapWith((DataSet)input).transform((StateBootstrapFunction)new ExampleStateBootstrapFunction());
        List<OperatorState> operatorStates = Collections.singletonList(new OperatorState(OperatorIDGenerator.fromUid((String)UID), 1, 4));
        SavepointMetadata metadata = new SavepointMetadata(4, Collections.emptyList(), operatorStates);
        ((ExistingSavepoint)new ExistingSavepoint(env, metadata, (StateBackend)new MemoryStateBackend()).withOperator(UID, transformation)).withOperator(UID, transformation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistingSavepointEnforceUniqueUIDsWithOldSavepoint() throws IOException {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(10);
        DataSource input = env.fromElements((Object[])new Integer[]{0});
        BootstrapTransformation transformation = OperatorTransformation.bootstrapWith((DataSet)input).transform((StateBootstrapFunction)new ExampleStateBootstrapFunction());
        List<OperatorState> operatorStates = Collections.singletonList(new OperatorState(OperatorIDGenerator.fromUid((String)UID), 1, 4));
        SavepointMetadata metadata = new SavepointMetadata(4, Collections.emptyList(), operatorStates);
        ((ExistingSavepoint)new ExistingSavepoint(env, metadata, (StateBackend)new MemoryStateBackend()).withOperator(UID, transformation)).write("");
    }

    private static class ExampleStateBootstrapFunction
    extends StateBootstrapFunction<Integer> {
        private ExampleStateBootstrapFunction() {
        }

        public void processElement(Integer value, StateBootstrapFunction.Context ctx) throws Exception {
        }

        public void snapshotState(FunctionSnapshotContext context) throws Exception {
        }

        public void initializeState(FunctionInitializationContext context) throws Exception {
        }
    }
}

