/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.common.utils.PulsarExceptionUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;

@Internal
public final class PulsarClientFactory {
    private PulsarClientFactory() {
    }

    public static PulsarClient createClient(PulsarConfiguration configuration) {
        ClientBuilder builder = PulsarClient.builder();
        Integer requestTimeoutMs = (Integer)configuration.get(PulsarOptions.PULSAR_REQUEST_TIMEOUT_MS);
        builder.loadConf(Collections.singletonMap("requestTimeoutMs", requestTimeoutMs));
        builder.authentication(PulsarClientFactory.createAuthentication(configuration));
        configuration.useOption(PulsarOptions.PULSAR_SERVICE_URL, builder::serviceUrl);
        configuration.useOption(PulsarOptions.PULSAR_LISTENER_NAME, builder::listenerName);
        configuration.useOption(PulsarOptions.PULSAR_OPERATION_TIMEOUT_MS, timeout -> builder.operationTimeout((int)timeout, TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_NUM_IO_THREADS, builder::ioThreads);
        configuration.useOption(PulsarOptions.PULSAR_NUM_LISTENER_THREADS, builder::listenerThreads);
        configuration.useOption(PulsarOptions.PULSAR_CONNECTIONS_PER_BROKER, builder::connectionsPerBroker);
        configuration.useOption(PulsarOptions.PULSAR_USE_TCP_NO_DELAY, builder::enableTcpNoDelay);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_CERTS_FILE_PATH, builder::tlsTrustCertsFilePath);
        configuration.useOption(PulsarOptions.PULSAR_TLS_ALLOW_INSECURE_CONNECTION, builder::allowTlsInsecureConnection);
        configuration.useOption(PulsarOptions.PULSAR_TLS_HOSTNAME_VERIFICATION_ENABLE, builder::enableTlsHostnameVerification);
        configuration.useOption(PulsarOptions.PULSAR_USE_KEY_STORE_TLS, builder::useKeyStoreTls);
        configuration.useOption(PulsarOptions.PULSAR_SSL_PROVIDER, builder::sslProvider);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_TYPE, builder::tlsTrustStoreType);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PATH, builder::tlsTrustStorePath);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PASSWORD, builder::tlsTrustStorePassword);
        configuration.useOption(PulsarOptions.PULSAR_TLS_CIPHERS, TreeSet::new, builder::tlsCiphers);
        configuration.useOption(PulsarOptions.PULSAR_TLS_PROTOCOLS, TreeSet::new, builder::tlsProtocols);
        configuration.useOption(PulsarOptions.PULSAR_MEMORY_LIMIT_BYTES, bytes -> builder.memoryLimit((long)bytes, SizeUnit.BYTES));
        configuration.useOption(PulsarOptions.PULSAR_STATS_INTERVAL_SECONDS, v -> builder.statsInterval((long)v, TimeUnit.SECONDS));
        configuration.useOption(PulsarOptions.PULSAR_CONCURRENT_LOOKUP_REQUEST, builder::maxConcurrentLookupRequests);
        configuration.useOption(PulsarOptions.PULSAR_MAX_LOOKUP_REQUEST, builder::maxLookupRequests);
        configuration.useOption(PulsarOptions.PULSAR_MAX_LOOKUP_REDIRECTS, builder::maxLookupRedirects);
        configuration.useOption(PulsarOptions.PULSAR_MAX_NUMBER_OF_REJECTED_REQUEST_PER_CONNECTION, builder::maxNumberOfRejectedRequestPerConnection);
        configuration.useOption(PulsarOptions.PULSAR_KEEP_ALIVE_INTERVAL_SECONDS, v -> builder.keepAliveInterval((int)v, TimeUnit.SECONDS));
        configuration.useOption(PulsarOptions.PULSAR_CONNECTION_TIMEOUT_MS, v -> builder.connectionTimeout((int)v, TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_INITIAL_BACKOFF_INTERVAL_NANOS, v -> builder.startingBackoffInterval((long)v, TimeUnit.NANOSECONDS));
        configuration.useOption(PulsarOptions.PULSAR_MAX_BACKOFF_INTERVAL_NANOS, v -> builder.maxBackoffInterval((long)v, TimeUnit.NANOSECONDS));
        configuration.useOption(PulsarOptions.PULSAR_ENABLE_BUSY_WAIT, builder::enableBusyWait);
        if (configuration.contains(PulsarOptions.PULSAR_PROXY_SERVICE_URL)) {
            String proxyServiceUrl = (String)configuration.get(PulsarOptions.PULSAR_PROXY_SERVICE_URL);
            ProxyProtocol proxyProtocol = (ProxyProtocol)((Object)configuration.get(PulsarOptions.PULSAR_PROXY_PROTOCOL));
            builder.proxyServiceUrl(proxyServiceUrl, proxyProtocol);
        }
        configuration.useOption(PulsarOptions.PULSAR_ENABLE_TRANSACTION, builder::enableTransaction);
        return (PulsarClient)PulsarExceptionUtils.sneakyClient(builder::build);
    }

    public static PulsarAdmin createAdmin(PulsarConfiguration configuration) {
        PulsarAdminBuilder builder = PulsarAdmin.builder();
        builder.authentication(PulsarClientFactory.createAuthentication(configuration));
        configuration.useOption(PulsarOptions.PULSAR_ADMIN_URL, builder::serviceHttpUrl);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_CERTS_FILE_PATH, builder::tlsTrustCertsFilePath);
        configuration.useOption(PulsarOptions.PULSAR_TLS_ALLOW_INSECURE_CONNECTION, builder::allowTlsInsecureConnection);
        configuration.useOption(PulsarOptions.PULSAR_TLS_HOSTNAME_VERIFICATION_ENABLE, builder::enableTlsHostnameVerification);
        configuration.useOption(PulsarOptions.PULSAR_USE_KEY_STORE_TLS, builder::useKeyStoreTls);
        configuration.useOption(PulsarOptions.PULSAR_SSL_PROVIDER, builder::sslProvider);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_TYPE, builder::tlsTrustStoreType);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PATH, builder::tlsTrustStorePath);
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PASSWORD, builder::tlsTrustStorePassword);
        configuration.useOption(PulsarOptions.PULSAR_TLS_CIPHERS, TreeSet::new, builder::tlsCiphers);
        configuration.useOption(PulsarOptions.PULSAR_TLS_PROTOCOLS, TreeSet::new, builder::tlsProtocols);
        configuration.useOption(PulsarOptions.PULSAR_CONNECT_TIMEOUT, v -> builder.connectionTimeout((int)v, TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_READ_TIMEOUT, v -> builder.readTimeout((int)v, TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_REQUEST_TIMEOUT, v -> builder.requestTimeout((int)v, TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_AUTO_CERT_REFRESH_TIME, v -> builder.autoCertRefreshTime((int)v, TimeUnit.MILLISECONDS));
        return (PulsarAdmin)PulsarExceptionUtils.sneakyClient(builder::build);
    }

    private static Authentication createAuthentication(PulsarConfiguration configuration) {
        if (configuration.contains(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME)) {
            String authPluginClassName = (String)configuration.get(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME);
            if (configuration.contains(PulsarOptions.PULSAR_AUTH_PARAMS)) {
                String authParamsString = (String)configuration.get(PulsarOptions.PULSAR_AUTH_PARAMS);
                return (Authentication)PulsarExceptionUtils.sneakyClient(() -> AuthenticationFactory.create(authPluginClassName, authParamsString));
            }
            Map<String, String> paramsMap = configuration.getProperties(PulsarOptions.PULSAR_AUTH_PARAM_MAP);
            if (paramsMap.isEmpty()) {
                throw new IllegalArgumentException(String.format("No %s or %s provided", PulsarOptions.PULSAR_AUTH_PARAMS.key(), PulsarOptions.PULSAR_AUTH_PARAM_MAP.key()));
            }
            return (Authentication)PulsarExceptionUtils.sneakyClient(() -> AuthenticationFactory.create(authPluginClassName, paramsMap));
        }
        return AuthenticationDisabled.INSTANCE;
    }
}

