/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.org.bson.json;

import org.apache.flink.mongodb.shaded.org.bson.json.Converter;
import org.apache.flink.mongodb.shaded.org.bson.json.DateTimeFormatter;
import org.apache.flink.mongodb.shaded.org.bson.json.ExtendedJsonDateTimeConverter;
import org.apache.flink.mongodb.shaded.org.bson.json.StrictJsonWriter;

class RelaxedExtendedJsonDateTimeConverter
implements Converter<Long> {
    private static final Converter<Long> FALLBACK_CONVERTER = new ExtendedJsonDateTimeConverter();
    private static final long LAST_MS_OF_YEAR_9999 = 253402300799999L;

    RelaxedExtendedJsonDateTimeConverter() {
    }

    @Override
    public void convert(Long value, StrictJsonWriter writer) {
        if (value < 0L || value > 253402300799999L) {
            FALLBACK_CONVERTER.convert(value, writer);
        } else {
            writer.writeStartObject();
            writer.writeString("$date", DateTimeFormatter.format(value));
            writer.writeEndObject();
        }
    }
}

