/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.org.bson.codecs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.mongodb.shaded.org.bson.BsonReader;
import org.apache.flink.mongodb.shaded.org.bson.BsonType;
import org.apache.flink.mongodb.shaded.org.bson.BsonWriter;
import org.apache.flink.mongodb.shaded.org.bson.Transformer;
import org.apache.flink.mongodb.shaded.org.bson.UuidRepresentation;
import org.apache.flink.mongodb.shaded.org.bson.assertions.Assertions;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonTypeClassMap;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonTypeCodecMap;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonValueCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.ContainerCodecHelper;
import org.apache.flink.mongodb.shaded.org.bson.codecs.DecoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.DocumentCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.EncoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.IterableCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.MapCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.OverridableUuidRepresentationCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.ValueCodecProvider;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistries;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;

public class MapCodec
implements Codec<Map<String, Object>>,
OverridableUuidRepresentationCodec<Map<String, Object>> {
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new IterableCodecProvider(), new MapCodecProvider()));
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    public MapCodec() {
        this(DEFAULT_REGISTRY);
    }

    public MapCodec(CodecRegistry registry) {
        this(registry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public MapCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public MapCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, UuidRepresentation.UNSPECIFIED);
    }

    private MapCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, UuidRepresentation uuidRepresentation) {
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            @Override
            public Object transform(Object value) {
                return value;
            }
        };
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<Map<String, Object>> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new MapCodec(this.registry, this.bsonTypeCodecMap, this.valueTransformer, uuidRepresentation);
    }

    @Override
    public void encode(BsonWriter writer, Map<String, Object> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    @Override
    public Map<String, Object> decode(BsonReader reader, DecoderContext decoderContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            map.put(fieldName, ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer));
        }
        reader.readEndDocument();
        return map;
    }

    @Override
    public Class<Map<String, Object>> getEncoderClass() {
        return Map.class;
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Codec<?> codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
    }
}

