/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.management;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionId;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerId;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionCheckedInEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionCheckedOutEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionClosedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionCreatedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionPoolClosedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionPoolCreatedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ConnectionPoolListener;
import org.apache.flink.mongodb.shaded.com.mongodb.management.ConnectionPoolStatistics;
import org.apache.flink.mongodb.shaded.com.mongodb.management.ConnectionPoolStatisticsMBean;
import org.apache.flink.mongodb.shaded.com.mongodb.management.MBeanServerFactory;

public class JMXConnectionPoolListener
implements ConnectionPoolListener {
    private final ConcurrentMap<ServerId, ConnectionPoolStatistics> map = new ConcurrentHashMap<ServerId, ConnectionPoolStatistics>();

    @Override
    public void connectionPoolCreated(ConnectionPoolCreatedEvent event) {
        ConnectionPoolStatistics statistics = new ConnectionPoolStatistics(event);
        this.map.put(event.getServerId(), statistics);
        MBeanServerFactory.getMBeanServer().registerMBean(statistics, this.getMBeanObjectName(event.getServerId()));
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        this.map.remove(event.getServerId());
        MBeanServerFactory.getMBeanServer().unregisterMBean(this.getMBeanObjectName(event.getServerId()));
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionCheckedOut(event);
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionCheckedIn(event);
        }
    }

    @Override
    public void connectionCreated(ConnectionCreatedEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionCreated(event);
        }
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionClosed(event);
        }
    }

    String getMBeanObjectName(ServerId serverId) {
        String name = String.format("org.mongodb.driver:type=ConnectionPool,clusterId=%s,host=%s,port=%s", this.ensureValidValue(serverId.getClusterId().getValue()), this.ensureValidValue(serverId.getAddress().getHost()), serverId.getAddress().getPort());
        if (serverId.getClusterId().getDescription() != null) {
            name = String.format("%s,description=%s", name, this.ensureValidValue(serverId.getClusterId().getDescription()));
        }
        return name;
    }

    ConnectionPoolStatisticsMBean getMBean(ServerId serverId) {
        return this.getStatistics(serverId);
    }

    private ConnectionPoolStatistics getStatistics(ConnectionId connectionId) {
        return this.getStatistics(connectionId.getServerId());
    }

    private ConnectionPoolStatistics getStatistics(ServerId serverId) {
        return (ConnectionPoolStatistics)this.map.get(serverId);
    }

    private String ensureValidValue(String value) {
        if (this.containsQuotableCharacter(value)) {
            return ObjectName.quote(value);
        }
        return value;
    }

    private boolean containsQuotableCharacter(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        List<String> quoteableCharacters = Arrays.asList(",", ":", "?", "*", "=", "\"", "\\", "\n");
        for (String quotable : quoteableCharacters) {
            if (!value.contains(quotable)) continue;
            return true;
        }
        return false;
    }
}

