/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.selector;

import java.util.Collections;
import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterDescriptionHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.selector.ServerSelector;

public class ServerAddressSelector
implements ServerSelector {
    private final ServerAddress serverAddress;

    public ServerAddressSelector(ServerAddress serverAddress) {
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ServerDescription serverDescription = ClusterDescriptionHelper.getByServerAddress(clusterDescription, this.serverAddress);
        if (serverDescription != null) {
            return Collections.singletonList(serverDescription);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "ServerAddressSelector{serverAddress=" + this.serverAddress + '}';
    }
}

