/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import org.apache.flink.mongodb.shaded.com.mongodb.Function;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncWriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.WriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncWriteOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandOperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.WriteOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDocumentCodec;

public abstract class TransactionOperation
implements WriteOperation<Void>,
AsyncWriteOperation<Void> {
    private final WriteConcern writeConcern;

    TransactionOperation(WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding) {
        Assertions.isTrue("in transaction", binding.getSessionContext().hasActiveTransaction());
        return CommandOperationHelper.executeRetryableWrite(binding, "admin", null, new NoOpFieldNameValidator(), new BsonDocumentCodec(), this.getCommandCreator(), CommandOperationHelper.writeConcernErrorTransformer(), this.getRetryCommandModifier());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        Assertions.isTrue("in transaction", binding.getSessionContext().hasActiveTransaction());
        CommandOperationHelper.executeRetryableWriteAsync(binding, "admin", null, new NoOpFieldNameValidator(), new BsonDocumentCodec(), this.getCommandCreator(), CommandOperationHelper.writeConcernErrorTransformerAsync(), this.getRetryCommandModifier(), ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    CommandOperationHelper.CommandCreator getCommandCreator() {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                BsonDocument command = new BsonDocument(TransactionOperation.this.getCommandName(), new BsonInt32(1));
                if (!TransactionOperation.this.writeConcern.isServerDefault()) {
                    command.put("writeConcern", TransactionOperation.this.writeConcern.asDocument());
                }
                return command;
            }
        };
    }

    protected abstract String getCommandName();

    protected abstract Function<BsonDocument, BsonDocument> getRetryCommandModifier();
}

