/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ReadConcernHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;

final class OperationReadConcernHelper {
    static void appendReadConcernToCommand(SessionContext sessionContext, int maxWireVersion, BsonDocument commandDocument) {
        Assertions.notNull("commandDocument", commandDocument);
        Assertions.notNull("sessionContext", sessionContext);
        if (sessionContext.hasActiveTransaction()) {
            return;
        }
        if (sessionContext.isSnapshot()) {
            return;
        }
        BsonDocument readConcernDocument = ReadConcernHelper.getReadConcernDocument(sessionContext, maxWireVersion);
        if (!readConcernDocument.isEmpty()) {
            commandDocument.append("readConcern", readConcernDocument);
        }
    }

    private OperationReadConcernHelper() {
    }
}

