/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandOperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandResultDocumentCodec;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.DocumentHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationReadConcernHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDocumentCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;

public class EstimatedDocumentCountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private long maxTimeMS;
    private BsonValue comment;

    public EstimatedDocumentCountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public EstimatedDocumentCountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        try {
            return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException e) {
            return CommandOperationHelper.rethrowIfNotNamespaceError(e, 0L);
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (result, t) -> {
            if (CommandOperationHelper.isNamespaceError(t)) {
                callback.onResult(0L, null);
            } else {
                callback.onResult((Long)result, t);
            }
        });
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private long transformResult(BsonDocument result, ConnectionDescription connectionDescription) {
        return result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> {
            OperationHelper.validateReadConcern(connectionDescription, sessionContext.getReadConcern());
            BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document);
            DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
            if (this.comment != null) {
                document.put("comment", this.comment);
            }
            return document;
        };
    }
}

