/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncWriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.WriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AsyncConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncWriteOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandOperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.WriteConcernHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.WriteOperation;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;

public class DropDatabaseOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final BsonDocument DROP_DATABASE = new BsonDocument("dropDatabase", new BsonInt32(1));
    private final String databaseName;
    private final WriteConcern writeConcern;

    public DropDatabaseOperation(String databaseName) {
        this(databaseName, null);
    }

    public DropDatabaseOperation(String databaseName, WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                CommandOperationHelper.executeCommand(binding, DropDatabaseOperation.this.databaseName, DropDatabaseOperation.this.getCommand(connection.getDescription()), connection, CommandOperationHelper.writeConcernErrorTransformer());
                return null;
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    CommandOperationHelper.executeCommandAsync(binding, DropDatabaseOperation.this.databaseName, DropDatabaseOperation.this.getCommand(connection.getDescription()), connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), OperationHelper.releasingCallback(errHandlingCallback, connection));
                }
            }
        });
    }

    private BsonDocument getCommand(ConnectionDescription description) {
        BsonDocument commandDocument = new BsonDocument("dropDatabase", new BsonInt32(1));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument, description);
        return commandDocument;
    }
}

