/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.Function;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoExecutionTimeoutException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNodeIsRecoveringException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNotPrimaryException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoTimeoutException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoWriteConcernException;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncWriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.WriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandOperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.TransactionOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;

public class CommitTransactionOperation
extends TransactionOperation {
    private final boolean alreadyCommitted;
    private BsonDocument recoveryToken;
    private Long maxCommitTimeMS;
    private static final List<Integer> NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES = Arrays.asList(79, 100);

    public CommitTransactionOperation(WriteConcern writeConcern) {
        this(writeConcern, false);
    }

    public CommitTransactionOperation(WriteConcern writeConcern, boolean alreadyCommitted) {
        super(writeConcern);
        this.alreadyCommitted = alreadyCommitted;
    }

    public CommitTransactionOperation recoveryToken(BsonDocument recoveryToken) {
        this.recoveryToken = recoveryToken;
        return this;
    }

    public CommitTransactionOperation maxCommitTime(@Nullable Long maxCommitTime, TimeUnit timeUnit) {
        if (maxCommitTime == null) {
            this.maxCommitTimeMS = null;
        } else {
            Assertions.notNull("timeUnit", timeUnit);
            Assertions.isTrueArgument("maxCommitTime > 0", maxCommitTime > 0L);
            this.maxCommitTimeMS = TimeUnit.MILLISECONDS.convert(maxCommitTime, timeUnit);
        }
        return this;
    }

    @Nullable
    public Long getMaxCommitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.maxCommitTimeMS == null) {
            return null;
        }
        return timeUnit.convert(this.maxCommitTimeMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public Void execute(WriteBinding binding) {
        try {
            return super.execute(binding);
        }
        catch (MongoException e) {
            this.addErrorLabels(e);
            throw e;
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        super.executeAsync(binding, new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t instanceof MongoException) {
                    CommitTransactionOperation.this.addErrorLabels((MongoException)t);
                }
                callback.onResult(result, t);
            }
        });
    }

    private void addErrorLabels(MongoException e) {
        if (CommitTransactionOperation.shouldAddUnknownTransactionCommitResultLabel(e)) {
            e.addLabel("UnknownTransactionCommitResult");
        }
    }

    private static boolean shouldAddUnknownTransactionCommitResultLabel(MongoException e) {
        if (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoNotPrimaryException || e instanceof MongoNodeIsRecoveringException || e instanceof MongoExecutionTimeoutException) {
            return true;
        }
        if (e.hasErrorLabel("RetryableWriteError")) {
            return true;
        }
        if (e instanceof MongoWriteConcernException) {
            return !NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES.contains(e.getCode());
        }
        return false;
    }

    @Override
    protected String getCommandName() {
        return "commitTransaction";
    }

    @Override
    CommandOperationHelper.CommandCreator getCommandCreator() {
        final CommandOperationHelper.CommandCreator creator = new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                BsonDocument command = CommitTransactionOperation.super.getCommandCreator().create(serverDescription, connectionDescription);
                if (CommitTransactionOperation.this.maxCommitTimeMS != null) {
                    command.append("maxTimeMS", CommitTransactionOperation.this.maxCommitTimeMS > Integer.MAX_VALUE ? new BsonInt64(CommitTransactionOperation.this.maxCommitTimeMS) : new BsonInt32(CommitTransactionOperation.this.maxCommitTimeMS.intValue()));
                }
                return command;
            }
        };
        if (this.alreadyCommitted) {
            return new CommandOperationHelper.CommandCreator(){

                @Override
                public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                    return CommitTransactionOperation.this.getRetryCommandModifier().apply(creator.create(serverDescription, connectionDescription));
                }
            };
        }
        if (this.recoveryToken != null) {
            return new CommandOperationHelper.CommandCreator(){

                @Override
                public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                    return creator.create(serverDescription, connectionDescription).append("recoveryToken", CommitTransactionOperation.this.recoveryToken);
                }
            };
        }
        return creator;
    }

    @Override
    protected Function<BsonDocument, BsonDocument> getRetryCommandModifier() {
        return new Function<BsonDocument, BsonDocument>(){

            @Override
            public BsonDocument apply(BsonDocument command) {
                WriteConcern retryWriteConcern = CommitTransactionOperation.this.getWriteConcern().withW("majority");
                if (retryWriteConcern.getWTimeout(TimeUnit.MILLISECONDS) == null) {
                    retryWriteConcern = retryWriteConcern.withWTimeout(10000L, TimeUnit.MILLISECONDS);
                }
                command.put("writeConcern", retryWriteConcern.asDocument());
                if (CommitTransactionOperation.this.recoveryToken != null) {
                    command.put("recoveryToken", CommitTransactionOperation.this.recoveryToken);
                }
                return command;
            }
        };
    }
}

