/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.mongodb.shaded.com.mongodb.Function;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoClientException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoConnectionPoolClearedException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNodeIsRecoveringException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNotPrimaryException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSecurityException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoServerException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketException;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function.AsyncCallbackSupplier;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function.RetryState;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function.RetryingSyncSupplier;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncConnectionSource;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncWriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ConnectionSource;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.WriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AsyncConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.OperationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.WriteConcernHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.retry.AttachmentKeys;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.FieldNameValidator;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDocumentCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;

final class CommandOperationHelper {
    private static final List<Integer> RETRYABLE_ERROR_CODES = Arrays.asList(6, 7, 89, 91, 189, 262, 9001, 13436, 13435, 11602, 11600, 10107);
    static final String RETRYABLE_WRITE_ERROR_LABEL = "RetryableWriteError";

    static CommandWriteTransformer<BsonDocument, Void> writeConcernErrorTransformer() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    static CommandWriteTransformerAsync<BsonDocument, Void> writeConcernErrorWriteTransformer() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    static CommandWriteTransformerAsync<BsonDocument, Void> writeConcernErrorTransformerAsync() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    private static Throwable chooseRetryableReadException(@Nullable Throwable previouslyChosenException, Throwable mostRecentAttemptException) {
        Assertions.assertFalse(mostRecentAttemptException instanceof OperationHelper.ResourceSupplierInternalException);
        if (previouslyChosenException == null || mostRecentAttemptException instanceof MongoSocketException || mostRecentAttemptException instanceof MongoServerException) {
            return mostRecentAttemptException;
        }
        return previouslyChosenException;
    }

    static Throwable chooseRetryableWriteException(@Nullable Throwable previouslyChosenException, Throwable mostRecentAttemptException) {
        if (previouslyChosenException == null) {
            if (mostRecentAttemptException instanceof OperationHelper.ResourceSupplierInternalException) {
                return mostRecentAttemptException.getCause();
            }
            return mostRecentAttemptException;
        }
        if (mostRecentAttemptException instanceof OperationHelper.ResourceSupplierInternalException) {
            return previouslyChosenException;
        }
        return mostRecentAttemptException;
    }

    static RetryState initialRetryState(boolean retry) {
        return new RetryState(retry ? 1 : 0);
    }

    static <R> Supplier<R> decorateReadWithRetries(RetryState retryState, Supplier<R> readFunction) {
        return new RetryingSyncSupplier<R>(retryState, CommandOperationHelper::chooseRetryableReadException, CommandOperationHelper::shouldAttemptToRetryRead, readFunction);
    }

    static <R> AsyncCallbackSupplier<R> decorateReadWithRetries(RetryState retryState, AsyncCallbackSupplier<R> asyncReadFunction) {
        return new RetryingAsyncCallbackSupplier<R>(retryState, CommandOperationHelper::chooseRetryableReadException, CommandOperationHelper::shouldAttemptToRetryRead, asyncReadFunction);
    }

    static <D, T> T executeRetryableRead(ReadBinding binding, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        return CommandOperationHelper.executeRetryableRead(binding, binding::getReadConnectionSource, database, commandCreator, decoder, transformer, retryReads);
    }

    static <D, T> T executeRetryableRead(ReadBinding binding, Supplier<ConnectionSource> readConnectionSourceSupplier, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        RetryState retryState = CommandOperationHelper.initialRetryState(retryReads);
        Supplier<Object> read = CommandOperationHelper.decorateReadWithRetries(retryState, () -> {
            CommandOperationHelper.logRetryExecute(retryState);
            return OperationHelper.withSourceAndConnection(readConnectionSourceSupplier, false, (source, connection) -> {
                retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()));
                return CommandOperationHelper.createReadCommandAndExecute(retryState, binding, source, database, commandCreator, decoder, transformer, connection);
            });
        });
        return (T)read.get();
    }

    static <D, T> T createReadCommandAndExecute(RetryState retryState, ReadBinding binding, ConnectionSource source, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, Connection connection) {
        BsonDocument command = commandCreator.create(source.getServerDescription(), connection.getDescription());
        retryState.attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, false);
        CommandOperationHelper.logRetryExecute(retryState);
        return transformer.apply(connection.command(database, command, new NoOpFieldNameValidator(), source.getReadPreference(), decoder, binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext()), source, connection);
    }

    static <D, T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandWriteTransformer<D, T> transformer) {
        return (T)OperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, false, (source, connection) -> transformer.apply((Object)connection.command(database, command, new NoOpFieldNameValidator(), ReadPreference.primary(), decoder, source.getSessionContext(), source.getServerApi(), binding.getRequestContext()), (Connection)connection));
    }

    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Connection connection, CommandWriteTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return transformer.apply(connection.command(database, command, new NoOpFieldNameValidator(), ReadPreference.primary(), new BsonDocumentCodec(), binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext()), connection);
    }

    static <D, T> void executeRetryableReadAsync(AsyncReadBinding binding, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, binding::getReadConnectionSource, database, commandCreator, decoder, transformer, retryReads, callback);
    }

    static <D, T> void executeRetryableReadAsync(AsyncReadBinding binding, AsyncCallbackSupplier<AsyncConnectionSource> sourceAsyncSupplier, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, SingleResultCallback<T> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(retryReads);
        binding.retain();
        AsyncCallbackSupplier<T> asyncRead = CommandOperationHelper.decorateReadWithRetries(retryState, (SingleResultCallback<R> funcCallback) -> {
            CommandOperationHelper.logRetryExecute(retryState);
            OperationHelper.withAsyncSourceAndConnection(sourceAsyncSupplier, false, funcCallback, (source, connection, releasingCallback) -> {
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()), releasingCallback)) {
                    return;
                }
                CommandOperationHelper.createReadCommandAndExecuteAsync(retryState, binding, source, database, commandCreator, decoder, transformer, connection, releasingCallback);
            });
        }).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    static <D, T> void createReadCommandAndExecuteAsync(RetryState retryState, AsyncReadBinding binding, AsyncConnectionSource source, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, AsyncConnection connection, SingleResultCallback<T> callback) {
        BsonDocument command;
        try {
            command = commandCreator.create(source.getServerDescription(), connection.getDescription());
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, false);
            CommandOperationHelper.logRetryExecute(retryState);
        }
        catch (IllegalArgumentException e) {
            callback.onResult(null, e);
            return;
        }
        connection.commandAsync(database, command, new NoOpFieldNameValidator(), source.getReadPreference(), decoder, binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext(), CommandOperationHelper.transformingReadCallback(transformer, source, connection, callback));
    }

    private static <T, R> SingleResultCallback<T> transformingReadCallback(CommandReadTransformerAsync<T, R> transformer, AsyncConnectionSource source, AsyncConnection connection, SingleResultCallback<R> callback) {
        return (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                Object transformedResult;
                try {
                    transformedResult = transformer.apply(result, source, connection);
                }
                catch (Throwable e) {
                    callback.onResult(null, e);
                    return;
                }
                callback.onResult(transformedResult, null);
            }
        };
    }

    private static <T, R> SingleResultCallback<T> transformingWriteCallback(CommandWriteTransformerAsync<T, R> transformer, AsyncConnection connection, SingleResultCallback<R> callback) {
        return (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                Object transformedResult;
                try {
                    transformedResult = transformer.apply(result, connection);
                }
                catch (Throwable e) {
                    callback.onResult(null, e);
                    return;
                }
                callback.onResult(transformedResult, null);
            }
        };
    }

    static <T> void executeCommandAsync(AsyncWriteBinding binding, String database, BsonDocument command, AsyncConnection connection, CommandWriteTransformerAsync<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        SingleResultCallback<T> addingRetryableLabelCallback = CommandOperationHelper.addingRetryableLabelCallback(callback, connection.getDescription().getMaxWireVersion());
        connection.commandAsync(database, command, new NoOpFieldNameValidator(), ReadPreference.primary(), new BsonDocumentCodec(), binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext(), CommandOperationHelper.transformingWriteCallback(transformer, connection, addingRetryableLabelCallback));
    }

    static <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, Supplier<R> writeFunction) {
        return new RetryingSyncSupplier<R>(retryState, CommandOperationHelper::chooseRetryableWriteException, CommandOperationHelper::shouldAttemptToRetryWrite, writeFunction);
    }

    static <R> AsyncCallbackSupplier<R> decorateWriteWithRetries(RetryState retryState, AsyncCallbackSupplier<R> asyncWriteFunction) {
        return new RetryingAsyncCallbackSupplier<R>(retryState, CommandOperationHelper::chooseRetryableWriteException, CommandOperationHelper::shouldAttemptToRetryWrite, asyncWriteFunction);
    }

    static <T, R> R executeRetryableWrite(WriteBinding binding, String database, ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandCreator commandCreator, CommandWriteTransformer<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true);
        Supplier<Object> retryingWrite = CommandOperationHelper.decorateWriteWithRetries(retryState, () -> {
            CommandOperationHelper.logRetryExecute(retryState);
            boolean firstAttempt = retryState.isFirstAttempt();
            if (!firstAttempt && binding.getSessionContext().hasActiveTransaction()) {
                binding.getSessionContext().clearTransactionContext();
            }
            return OperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, true, (source, connection) -> {
                int maxWireVersion = connection.getDescription().getMaxWireVersion();
                try {
                    retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryWrite(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()));
                    BsonDocument command = retryState.attachment(AttachmentKeys.command()).map(previousAttemptCommand -> {
                        Assertions.assertFalse(firstAttempt);
                        return (BsonDocument)retryCommandModifier.apply((BsonDocument)previousAttemptCommand);
                    }).orElseGet(() -> commandCreator.create(source.getServerDescription(), connection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), maxWireVersion, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(command), true).attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, true).attach(AttachmentKeys.command(), command, false);
                    CommandOperationHelper.logRetryExecute(retryState);
                    return transformer.apply(connection.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext()), (Connection)connection);
                }
                catch (MongoException e) {
                    if (!firstAttempt) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(e, maxWireVersion);
                    }
                    throw e;
                }
            });
        });
        try {
            return (R)retryingWrite.get();
        }
        catch (MongoException e) {
            throw CommandOperationHelper.transformWriteException(e);
        }
    }

    static <T, R> void executeRetryableWriteAsync(AsyncWriteBinding binding, String database, ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandCreator commandCreator, CommandWriteTransformerAsync<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier, SingleResultCallback<R> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true);
        binding.retain();
        AsyncCallbackSupplier<R> asyncWrite = CommandOperationHelper.decorateWriteWithRetries(retryState, (SingleResultCallback<R> funcCallback) -> {
            CommandOperationHelper.logRetryExecute(retryState);
            boolean firstAttempt = retryState.isFirstAttempt();
            if (!firstAttempt && binding.getSessionContext().hasActiveTransaction()) {
                binding.getSessionContext().clearTransactionContext();
            }
            OperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, true, funcCallback, (source, connection, releasingCallback) -> {
                BsonDocument command;
                SingleResultCallback addingRetryableLabelCallback;
                int maxWireVersion = connection.getDescription().getMaxWireVersion();
                SingleResultCallback singleResultCallback = addingRetryableLabelCallback = firstAttempt ? releasingCallback : CommandOperationHelper.addingRetryableLabelCallback(releasingCallback, maxWireVersion);
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryWrite(source.getServerDescription(), connection.getDescription(), binding.getSessionContext()), addingRetryableLabelCallback)) {
                    return;
                }
                try {
                    command = retryState.attachment(AttachmentKeys.command()).map(previousAttemptCommand -> {
                        Assertions.assertFalse(firstAttempt);
                        return (BsonDocument)retryCommandModifier.apply((BsonDocument)previousAttemptCommand);
                    }).orElseGet(() -> commandCreator.create(source.getServerDescription(), connection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), maxWireVersion, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(command), true).attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, true).attach(AttachmentKeys.command(), command, false);
                    CommandOperationHelper.logRetryExecute(retryState);
                }
                catch (Throwable t) {
                    addingRetryableLabelCallback.onResult(null, t);
                    return;
                }
                connection.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext(), CommandOperationHelper.transformingWriteCallback(transformer, connection, addingRetryableLabelCallback));
            });
        }).whenComplete(binding::release);
        asyncWrite.get(CommandOperationHelper.exceptionTransformingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER)));
    }

    private static <R> SingleResultCallback<R> addingRetryableLabelCallback(SingleResultCallback<R> callback, int maxWireVersion) {
        return (result, t) -> {
            if (t != null) {
                if (t instanceof MongoException) {
                    CommandOperationHelper.addRetryableWriteErrorLabel((MongoException)t, maxWireVersion);
                }
                callback.onResult(null, t);
            } else {
                callback.onResult(result, null);
            }
        };
    }

    static boolean isRetryableException(Throwable t) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        if (t instanceof MongoSocketException || t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException || t instanceof MongoConnectionPoolClearedException) {
            return true;
        }
        return RETRYABLE_ERROR_CODES.contains(((MongoException)t).getCode());
    }

    static void rethrowIfNotNamespaceError(MongoCommandException e) {
        CommandOperationHelper.rethrowIfNotNamespaceError(e, null);
    }

    static <T> T rethrowIfNotNamespaceError(MongoCommandException e, T defaultValue) {
        if (!CommandOperationHelper.isNamespaceError(e)) {
            throw e;
        }
        return defaultValue;
    }

    static boolean isNamespaceError(Throwable t) {
        if (t instanceof MongoCommandException) {
            MongoCommandException e = (MongoCommandException)t;
            return e.getErrorMessage().contains("ns not found") || e.getErrorCode() == 26;
        }
        return false;
    }

    private static boolean shouldAttemptToRetryRead(RetryState retryState, Throwable attemptFailure) {
        boolean decision;
        Assertions.assertFalse(attemptFailure instanceof OperationHelper.ResourceSupplierInternalException);
        boolean bl = decision = CommandOperationHelper.isRetryableException(attemptFailure) || attemptFailure instanceof MongoSecurityException && attemptFailure.getCause() != null && CommandOperationHelper.isRetryableException(attemptFailure.getCause());
        if (!decision) {
            CommandOperationHelper.logUnableToRetry(retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElse(null), attemptFailure);
        }
        return decision;
    }

    static boolean shouldAttemptToRetryWrite(RetryState retryState, Throwable attemptFailure) {
        Throwable failure = attemptFailure instanceof OperationHelper.ResourceSupplierInternalException ? attemptFailure.getCause() : attemptFailure;
        boolean decision = false;
        MongoException exceptionRetryableRegardlessOfCommand = null;
        if (failure instanceof MongoConnectionPoolClearedException || failure instanceof MongoSecurityException && failure.getCause() != null && CommandOperationHelper.isRetryableException(failure.getCause())) {
            decision = true;
            exceptionRetryableRegardlessOfCommand = (MongoException)failure;
        }
        if (retryState.attachment(AttachmentKeys.retryableCommandFlag()).orElse(false).booleanValue()) {
            if (exceptionRetryableRegardlessOfCommand != null) {
                exceptionRetryableRegardlessOfCommand.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
            } else if (CommandOperationHelper.decideRetryableAndAddRetryableWriteErrorLabel(failure, retryState.attachment(AttachmentKeys.maxWireVersion()).orElse(null))) {
                decision = true;
            } else {
                CommandOperationHelper.logUnableToRetry(retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElse(null), failure);
            }
        }
        return decision;
    }

    private static boolean isRetryWritesEnabled(@Nullable BsonDocument command) {
        return command != null && (command.containsKey("txnNumber") || command.getFirstKey().equals("commitTransaction") || command.getFirstKey().equals("abortTransaction"));
    }

    private static boolean decideRetryableAndAddRetryableWriteErrorLabel(Throwable t, @Nullable Integer maxWireVersion) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        MongoException exception = (MongoException)t;
        if (maxWireVersion != null) {
            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
        }
        return exception.hasErrorLabel(RETRYABLE_WRITE_ERROR_LABEL);
    }

    static void addRetryableWriteErrorLabel(MongoException exception, int maxWireVersion) {
        if (maxWireVersion >= 9 && exception instanceof MongoSocketException) {
            exception.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        } else if (maxWireVersion < 9 && CommandOperationHelper.isRetryableException(exception)) {
            exception.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        }
    }

    static void logRetryExecute(RetryState retryState) {
        if (OperationHelper.LOGGER.isDebugEnabled() && !retryState.isFirstAttempt()) {
            String commandDescription = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).map(Supplier::get).orElse(null);
            Throwable exception = retryState.exception().orElseThrow(Assertions::fail);
            int oneBasedAttempt = retryState.attempt() + 1;
            OperationHelper.LOGGER.debug(commandDescription == null ? String.format("Retrying an operation due to the error \"%s\"; attempt #%d", exception, oneBasedAttempt) : String.format("Retrying the operation %s due to the error \"%s\"; attempt #%d", commandDescription, exception, oneBasedAttempt));
        }
    }

    private static void logUnableToRetry(@Nullable Supplier<String> commandDescriptionSupplier, Throwable originalError) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            String commandDescription = commandDescriptionSupplier == null ? null : commandDescriptionSupplier.get();
            OperationHelper.LOGGER.debug(commandDescription == null ? String.format("Unable to retry an operation due to the error \"%s\"", originalError) : String.format("Unable to retry the operation %s due to the error \"%s\"", commandDescription, originalError));
        }
    }

    static MongoException transformWriteException(MongoException exception) {
        if (exception.getCode() == 20 && exception.getMessage().contains("Transaction numbers")) {
            MongoClientException clientException = new MongoClientException("This MongoDB deployment does not support retryable writes. Please add retryWrites=false to your connection string.", exception);
            for (String errorLabel : exception.getErrorLabels()) {
                clientException.addLabel(errorLabel);
            }
            return clientException;
        }
        return exception;
    }

    static <R> SingleResultCallback<R> exceptionTransformingCallback(SingleResultCallback<R> callback) {
        return (result, t) -> {
            if (t != null) {
                if (t instanceof MongoException) {
                    callback.onResult(null, CommandOperationHelper.transformWriteException((MongoException)t));
                } else {
                    callback.onResult(null, t);
                }
            } else {
                callback.onResult(result, null);
            }
        };
    }

    private CommandOperationHelper() {
    }

    static interface CommandWriteTransformer<T, R> {
        public R apply(T var1, Connection var2);
    }

    static interface CommandWriteTransformerAsync<T, R> {
        public R apply(T var1, AsyncConnection var2);
    }

    static interface CommandCreator {
        public BsonDocument create(ServerDescription var1, ConnectionDescription var2);
    }

    static interface CommandReadTransformer<T, R> {
        public R apply(T var1, ConnectionSource var2, Connection var3);
    }

    static interface CommandReadTransformerAsync<T, R> {
        public R apply(T var1, AsyncConnectionSource var2, AsyncConnection var3);
    }
}

