/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.operation;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.ExplainVerbosity;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Collation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.AsyncBatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AsyncReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ReadBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.client.model.AggregationLevel;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.NoOpSessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AggregateOperationImpl;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncExplainableReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.AsyncReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.BatchCursor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.CommandReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ExplainHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ExplainableReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ReadOperation;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;

public class AggregateOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private final AggregateOperationImpl<T> wrapped;

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this(namespace, pipeline, decoder, AggregationLevel.COLLECTION);
    }

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this.wrapped = new AggregateOperationImpl<T>(namespace, pipeline, decoder, aggregationLevel);
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Boolean getAllowDiskUse() {
        return this.wrapped.getAllowDiskUse();
    }

    public AggregateOperation<T> allowDiskUse(Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public AggregateOperation<T> batchSize(Integer batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        return this.wrapped.getMaxAwaitTime(timeUnit);
    }

    public AggregateOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return this.wrapped.getMaxTime(timeUnit);
    }

    public AggregateOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public AggregateOperation<T> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public AggregateOperation<T> comment(BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    public AggregateOperation<T> let(BsonDocument variables) {
        this.wrapped.let(variables);
        return this;
    }

    public AggregateOperation<T> retryReads(boolean retryReads) {
        this.wrapped.retryReads(retryReads);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    public BsonDocument getHint() {
        BsonValue hint = this.wrapped.getHint();
        if (hint == null) {
            return null;
        }
        if (!hint.isDocument()) {
            throw new IllegalArgumentException("Hint is not a BsonDocument please use the #getHintBsonValue() method. ");
        }
        return hint.asDocument();
    }

    public BsonValue getHintBsonValue() {
        return this.wrapped.getHint();
    }

    public AggregateOperation<T> hint(BsonValue hint) {
        this.wrapped.hint(hint);
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return this.wrapped.execute(binding);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.wrapped.executeAsync(binding, callback);
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), ExplainHelper.asExplainCommand(this.wrapped.getCommand(NoOpSessionContext.INSTANCE, 0), verbosity), resultDecoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), ExplainHelper.asExplainCommand(this.wrapped.getCommand(NoOpSessionContext.INSTANCE, 0), verbosity), resultDecoder);
    }

    MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    Decoder<T> getDecoder() {
        return this.wrapped.getDecoder();
    }

    public String toString() {
        return "AggregateOperation{namespace=" + this.getNamespace() + ", pipeline=" + this.getPipeline() + ", decoder=" + this.getDecoder() + ", allowDiskUse=" + this.getAllowDiskUse() + ", batchSize=" + this.getBatchSize() + ", collation=" + this.getCollation() + ", comment=" + this.getComment() + ", hint=" + this.getHint() + ", maxAwaitTimeMS=" + this.getMaxAwaitTime(TimeUnit.MILLISECONDS) + ", maxTimeMS=" + this.getMaxTime(TimeUnit.MILLISECONDS) + "}";
    }
}

