/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketOpenException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketReadException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.AsyncCompletionHandler;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.BufferProvider;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.SocketSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.SslSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.Stream;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SocketStreamHelper;
import org.apache.flink.mongodb.shaded.org.bson.ByteBuf;

public class SocketStream
implements Stream {
    private final ServerAddress address;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider;
    private volatile Socket socket;
    private volatile OutputStream outputStream;
    private volatile InputStream inputStream;
    private volatile boolean isClosed;

    public SocketStream(ServerAddress address, SocketSettings settings, SslSettings sslSettings, SocketFactory socketFactory, BufferProvider bufferProvider) {
        this.address = Assertions.notNull("address", address);
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = Assertions.notNull("socketFactory", socketFactory);
        this.bufferProvider = Assertions.notNull("bufferProvider", bufferProvider);
    }

    @Override
    public void open() {
        try {
            this.socket = this.initializeSocket();
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
        }
        catch (IOException e) {
            this.close();
            throw new MongoSocketOpenException("Exception opening socket", this.getAddress(), (Throwable)e);
        }
    }

    protected Socket initializeSocket() throws IOException {
        Iterator<InetSocketAddress> inetSocketAddresses = this.address.getSocketAddresses().iterator();
        while (inetSocketAddresses.hasNext()) {
            Socket socket = this.socketFactory.createSocket();
            try {
                SocketStreamHelper.initialize(socket, inetSocketAddresses.next(), this.settings, this.sslSettings);
                return socket;
            }
            catch (SocketTimeoutException e) {
                if (inetSocketAddresses.hasNext()) continue;
                throw e;
            }
        }
        throw new MongoSocketException("Exception opening socket", this.getAddress());
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.bufferProvider.getBuffer(size);
    }

    @Override
    public void write(List<ByteBuf> buffers) throws IOException {
        for (ByteBuf cur : buffers) {
            this.outputStream.write(cur.array(), 0, cur.limit());
        }
    }

    @Override
    public ByteBuf read(int numBytes) throws IOException {
        ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
        try {
            int bytesRead;
            byte[] bytes = buffer.array();
            for (int totalBytesRead = 0; totalBytesRead < buffer.limit(); totalBytesRead += bytesRead) {
                bytesRead = this.inputStream.read(bytes, totalBytesRead, buffer.limit() - totalBytesRead);
                if (bytesRead != -1) continue;
                throw new MongoSocketReadException("Prematurely reached end of stream", this.getAddress());
            }
            return buffer;
        }
        catch (Exception e) {
            buffer.release();
            throw e;
        }
    }

    @Override
    public boolean supportsAdditionalTimeout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf read(int numBytes, int additionalTimeout) throws IOException {
        int curTimeout = this.socket.getSoTimeout();
        if (curTimeout > 0 && additionalTimeout > 0) {
            this.socket.setSoTimeout(curTimeout + additionalTimeout);
        }
        try {
            ByteBuf byteBuf = this.read(numBytes);
            return byteBuf;
        }
        finally {
            this.socket.setSoTimeout(curTimeout);
        }
    }

    @Override
    public void openAsync(AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void readAsync(int numBytes, AsyncCompletionHandler<ByteBuf> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    SocketSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        try {
            this.isClosed = true;
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

