/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerCursor;

public class QueryResult<T> {
    private final MongoNamespace namespace;
    private final List<T> results;
    private final long cursorId;
    private final ServerAddress serverAddress;

    public QueryResult(MongoNamespace namespace, List<T> results, long cursorId, ServerAddress serverAddress) {
        this.namespace = namespace;
        this.results = results;
        this.cursorId = cursorId;
        this.serverAddress = serverAddress;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public ServerCursor getCursor() {
        return this.cursorId == 0L ? null : new ServerCursor(this.cursorId, this.serverAddress);
    }

    public List<T> getResults() {
        return this.results;
    }

    public ServerAddress getAddress() {
        return this.serverAddress;
    }

    public long getCursorId() {
        return this.cursorId;
    }
}

