/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSecurityException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.authentication.NativeAuthenticationHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Authenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoCredentialWithCache;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;

class NativeAuthenticator
extends Authenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");

    NativeAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    public void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            BsonDocument nonceResponse = CommandHelper.executeCommand(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), this.getClusterConnectionMode(), this.getServerApi(), connection);
            BsonDocument authCommand = NativeAuthenticationHelper.getAuthCommand(this.getUserNameNonNull(), this.getPasswordNonNull(), ((BsonString)nonceResponse.get("nonce")).getValue());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, this.getClusterConnectionMode(), this.getServerApi(), connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(final InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        final SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), this.getClusterConnectionMode(), this.getServerApi(), connection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument nonceResult, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                } else {
                    CommandHelper.executeCommandAsync(NativeAuthenticator.this.getMongoCredential().getSource(), NativeAuthenticationHelper.getAuthCommand(NativeAuthenticator.this.getUserNameNonNull(), NativeAuthenticator.this.getPasswordNonNull(), ((BsonString)nonceResult.get("nonce")).getValue()), NativeAuthenticator.this.getClusterConnectionMode(), NativeAuthenticator.this.getServerApi(), connection, new SingleResultCallback<BsonDocument>(){

                        @Override
                        public void onResult(BsonDocument result, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                            } else {
                                errHandlingCallback.onResult(null, null);
                            }
                        }
                    });
                }
            }
        });
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

