/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNodeIsRecoveringException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNotPrimaryException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSocketReadTimeoutException;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.ThreadSafe;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerConnectionState;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerId;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerType;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerClosedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerDescriptionChangedEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerListener;
import org.apache.flink.mongodb.shaded.com.mongodb.event.ServerOpeningEvent;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AsyncConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterClock;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterableServer;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ConnectionFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ConnectionPool;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ProtocolExecutor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.org.bson.types.ObjectId;

@ThreadSafe
public class LoadBalancedServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ConnectionFactory connectionFactory;
    private final ServerListener serverListener;
    private final ClusterClock clusterClock;

    public LoadBalancedServer(ServerId serverId, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerListener serverListener, ClusterClock clusterClock) {
        this.serverId = serverId;
        this.connectionPool = connectionPool;
        this.connectionFactory = connectionFactory;
        this.serverListener = serverListener;
        this.clusterClock = clusterClock;
        serverListener.serverOpening(new ServerOpeningEvent(serverId));
        serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(serverId, ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverId.getAddress()).build(), ServerDescription.builder().address(serverId.getAddress()).state(ServerConnectionState.CONNECTING).build()));
    }

    @Override
    public void resetToConnecting() {
    }

    @Override
    public void invalidate() {
    }

    private void invalidate(Throwable t, ObjectId serviceId, int generation) {
        if (!this.isClosed()) {
            if (t instanceof MongoSocketException && !(t instanceof MongoSocketReadTimeoutException)) {
                if (serviceId != null) {
                    this.connectionPool.invalidate(serviceId, generation);
                }
            } else if ((t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) && SHUTDOWN_CODES.contains(((MongoCommandException)t).getErrorCode()) && serviceId != null) {
                this.connectionPool.invalidate(serviceId, generation);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.connectionPool.close();
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void connect() {
    }

    @Override
    public Connection getConnection() {
        Assertions.isTrue("open", !this.isClosed());
        return this.connectionFactory.create(this.connectionPool.get(), new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED);
    }

    @Override
    public void getConnectionAsync(SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync((result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.connectionFactory.createAsync((InternalConnection)result, new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return -1;
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private class LoadBalancedServerProtocolExecutor
    implements ProtocolExecutor {
        private LoadBalancedServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
                return protocol.execute(connection);
            }
            catch (MongoWriteConcernWithResponseException e) {
                return (T)e.getResponse();
            }
            catch (MongoException e) {
                this.handleExecutionException(connection, sessionContext, e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
                if (t != null) {
                    if (t instanceof MongoWriteConcernWithResponseException) {
                        callback.onResult(((MongoWriteConcernWithResponseException)t).getResponse(), null);
                    } else {
                        this.handleExecutionException(connection, sessionContext, t);
                        callback.onResult(null, t);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }, LOGGER));
        }

        private void handleExecutionException(InternalConnection connection, SessionContext sessionContext, Throwable t) {
            LoadBalancedServer.this.invalidate(t, connection.getDescription().getServiceId(), connection.getGeneration());
            if (t instanceof MongoSocketException && sessionContext.hasSession()) {
                sessionContext.markSessionDirty();
            }
        }
    }
}

