/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCompressor;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCredential;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoDriverInformation;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.ThreadSafe;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerId;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.StreamFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandListener;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Cluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterableServer;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClusterableServerFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultConnectionFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultConnectionPool;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnectionPoolSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalStreamConnectionFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.LoadBalancedServer;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoCredentialWithCache;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.event.EventListenerHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.inject.EmptyProvider;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, MongoCredential credential, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, ServerApi serverApi) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance());
        connectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), connectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

