/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoCompressor;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoDriverInformation;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerId;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.StreamFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.event.CommandListener;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Authenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AwsAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ClientMetadataHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ConnectionGenerationSupplier;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DefaultAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.GSSAPIAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnectionFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalStreamConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalStreamConnectionInitializer;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoCredentialWithCache;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.PlainAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ScramShaAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.X509Authenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final ClusterConnectionMode clusterConnectionMode;
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> compressorList;
    private final CommandListener commandListener;
    @Nullable
    private final ServerApi serverApi;
    private final MongoCredentialWithCache credential;

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, StreamFactory streamFactory, MongoCredentialWithCache credential, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, CommandListener commandListener, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.commandListener = commandListener;
        this.serverApi = serverApi;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        this.credential = credential;
    }

    @Override
    public InternalConnection create(ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier) {
        Authenticator authenticator = this.credential == null ? null : this.createAuthenticator(this.credential);
        return new InternalStreamConnection(this.clusterConnectionMode, serverId, connectionGenerationSupplier, this.streamFactory, this.compressorList, this.commandListener, new InternalStreamConnectionInitializer(this.clusterConnectionMode, authenticator, this.clientMetadataDocument, this.compressorList, this.serverApi));
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
        }
        switch (credential.getAuthenticationMechanism()) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_AWS: {
                return new AwsAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

