/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import java.util.List;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.RequestContext;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.WriteConcernResult;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerType;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.DeleteRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.InsertRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.bulk.UpdateRequest;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AbstractReferenceCounted;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.AsyncConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandProtocolImpl;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.DeleteProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.GetMoreProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InsertProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.KillCursorProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.LegacyProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ProtocolExecutor;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.QueryProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.QueryResult;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SplittablePayload;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.UpdateProtocol;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.FieldNameValidator;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;

public class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    public DefaultServerConnection(InternalConnection wrapped, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = wrapped;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.close();
        }
        return count;
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, RequestContext requestContext) {
        return this.executeProtocol(new InsertProtocol(namespace, ordered, insertRequest, requestContext));
    }

    @Override
    public void insertAsync(MongoNamespace namespace, boolean ordered, InsertRequest insertRequest, RequestContext requestContext, SingleResultCallback<WriteConcernResult> callback) {
        this.executeProtocolAsync(new InsertProtocol(namespace, ordered, insertRequest, requestContext), callback);
    }

    @Override
    public WriteConcernResult update(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, RequestContext requestContext) {
        return this.executeProtocol(new UpdateProtocol(namespace, ordered, updateRequest, requestContext));
    }

    @Override
    public void updateAsync(MongoNamespace namespace, boolean ordered, UpdateRequest updateRequest, RequestContext requestContext, SingleResultCallback<WriteConcernResult> callback) {
        this.executeProtocolAsync(new UpdateProtocol(namespace, ordered, updateRequest, requestContext), callback);
    }

    @Override
    public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest, RequestContext requestContext) {
        return this.executeProtocol(new DeleteProtocol(namespace, ordered, deleteRequest, requestContext));
    }

    @Override
    public void deleteAsync(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest, RequestContext requestContext, SingleResultCallback<WriteConcernResult> callback) {
        this.executeProtocolAsync(new DeleteProtocol(namespace, ordered, deleteRequest, requestContext), callback);
    }

    @Override
    public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext) {
        return this.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, true, null, null);
    }

    @Override
    public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator) {
        return this.executeProtocol(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, serverApi, requestContext), sessionContext);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, ServerApi serverApi, RequestContext requestContext, SingleResultCallback<T> callback) {
        this.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, true, null, null, callback);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, ServerApi serverApi, RequestContext requestContext, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        this.executeProtocolAsync(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, serverApi, requestContext), sessionContext, callback);
    }

    @Override
    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean secondaryOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, RequestContext requestContext) {
        return (QueryResult)this.executeProtocol(new QueryProtocol<T>(namespace, skip, limit, batchSize, queryDocument, fields, resultDecoder, requestContext).tailableCursor(tailableCursor).secondaryOk(this.getSecondaryOk(secondaryOk)).oplogReplay(oplogReplay).noCursorTimeout(noCursorTimeout).awaitData(awaitData).partial(partial));
    }

    @Override
    public <T> void queryAsync(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int skip, int limit, int batchSize, boolean secondaryOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder, RequestContext requestContext, SingleResultCallback<QueryResult<T>> callback) {
        this.executeProtocolAsync(new QueryProtocol<T>(namespace, skip, limit, batchSize, queryDocument, fields, resultDecoder, requestContext).tailableCursor(tailableCursor).secondaryOk(this.getSecondaryOk(secondaryOk)).oplogReplay(oplogReplay).noCursorTimeout(noCursorTimeout).awaitData(awaitData).partial(partial), callback);
    }

    @Override
    public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, RequestContext requestContext) {
        return (QueryResult)this.executeProtocol(new GetMoreProtocol<T>(namespace, cursorId, numberToReturn, resultDecoder, requestContext));
    }

    @Override
    public <T> void getMoreAsync(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder, RequestContext requestContext, SingleResultCallback<QueryResult<T>> callback) {
        this.executeProtocolAsync(new GetMoreProtocol<T>(namespace, cursorId, numberToReturn, resultDecoder, requestContext), callback);
    }

    @Override
    public void killCursor(MongoNamespace namespace, List<Long> cursors, RequestContext requestContext) {
        this.executeProtocol(new KillCursorProtocol(namespace, cursors, requestContext));
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }

    @Override
    public void killCursorAsync(MongoNamespace namespace, List<Long> cursors, RequestContext requestContext, SingleResultCallback<Void> callback) {
        this.executeProtocolAsync(new KillCursorProtocol(namespace, cursors, requestContext), callback);
    }

    private boolean getSecondaryOk(boolean secondaryOk) {
        return secondaryOk || this.clusterConnectionMode == ClusterConnectionMode.SINGLE && this.wrapped.getDescription().getServerType() != ServerType.SHARD_ROUTER;
    }

    private <T> T executeProtocol(LegacyProtocol<T> protocol) {
        return this.protocolExecutor.execute(protocol, this.wrapped);
    }

    private <T> T executeProtocol(CommandProtocol<T> protocol, SessionContext sessionContext) {
        return this.protocolExecutor.execute(protocol, this.wrapped, sessionContext);
    }

    private <T> void executeProtocolAsync(LegacyProtocol<T> protocol, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, errHandlingCallback);
        }
        catch (Throwable t) {
            errHandlingCallback.onResult(null, t);
        }
    }

    private <T> void executeProtocolAsync(CommandProtocol<T> protocol, SessionContext sessionContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, sessionContext, errHandlingCallback);
        }
        catch (Throwable t) {
            errHandlingCallback.onResult(null, t);
        }
    }
}

