/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.AuthenticationMechanism;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoSecurityException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ConnectionDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Authenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.InternalConnection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.MongoCredentialWithCache;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.NativeAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ScramShaAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SpeculativeAuthenticator;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.operation.ServerVersionHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;

class DefaultAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    static final int USER_NOT_FOUND_CODE = 11;
    private static final BsonString DEFAULT_MECHANISM_NAME = new BsonString(AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());
    private Authenticator delegate;

    DefaultAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        Assertions.isTrueArgument("unspecified authentication mechanism", credential.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotZero(connectionDescription)) {
            this.getLegacyDefaultAuthenticator(connectionDescription).authenticate(connection, connectionDescription);
        } else {
            try {
                this.setDelegate(connectionDescription);
                this.delegate.authenticate(connection, connectionDescription);
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotZero(connectionDescription)) {
            this.getLegacyDefaultAuthenticator(connectionDescription).authenticateAsync(connection, connectionDescription, callback);
        } else {
            this.setDelegate(connectionDescription);
            this.delegate.authenticateAsync(connection, connectionDescription, callback);
        }
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        this.delegate = this.getAuthenticatorForHello();
        return ((SpeculativeAuthenticator)((Object)this.delegate)).createSpeculativeAuthenticateCommand(connection);
    }

    @Override
    public BsonDocument getSpeculativeAuthenticateResponse() {
        if (this.delegate != null) {
            return ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse();
        }
        return null;
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        ((SpeculativeAuthenticator)((Object)this.delegate)).setSpeculativeAuthenticateResponse(response);
    }

    private Authenticator getLegacyDefaultAuthenticator(ConnectionDescription connectionDescription) {
        if (ServerVersionHelper.serverIsAtLeastVersionThreeDotZero(connectionDescription)) {
            return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi());
        }
        return new NativeAuthenticator(this.getMongoCredentialWithCache(), this.getClusterConnectionMode(), this.getServerApi());
    }

    Authenticator getAuthenticatorForHello() {
        return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_256), this.getClusterConnectionMode(), this.getServerApi());
    }

    private void setDelegate(ConnectionDescription connectionDescription) {
        if (this.delegate != null && ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse() != null) {
            return;
        }
        if (connectionDescription.getSaslSupportedMechanisms() != null) {
            BsonArray saslSupportedMechs = connectionDescription.getSaslSupportedMechanisms();
            AuthenticationMechanism mechanism = saslSupportedMechs.contains(DEFAULT_MECHANISM_NAME) ? AuthenticationMechanism.SCRAM_SHA_256 : AuthenticationMechanism.SCRAM_SHA_1;
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(mechanism), this.getClusterConnectionMode(), this.getServerApi());
        } else {
            this.delegate = this.getLegacyDefaultAuthenticator(connectionDescription);
        }
    }

    private MongoException wrapException(Throwable t) {
        if (t instanceof MongoSecurityException) {
            return (MongoSecurityException)t;
        }
        if (t instanceof MongoException && ((MongoException)t).getCode() == 11) {
            return new MongoSecurityException(this.getMongoCredential(), String.format("Exception authenticating %s", this.getMongoCredential()), t);
        }
        return MongoException.fromThrowable(t);
    }
}

