/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Logger;
import org.apache.flink.mongodb.shaded.com.mongodb.diagnostics.logging.Loggers;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.CommandResultBaseCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ProtocolHelper;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocumentReader;
import org.apache.flink.mongodb.shaded.org.bson.codecs.BsonDocumentCodec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Decoder;
import org.apache.flink.mongodb.shaded.org.bson.codecs.DecoderContext;

class CommandResultCallback<T>
extends CommandResultBaseCallback<BsonDocument> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final SingleResultCallback<T> callback;
    private final Decoder<T> decoder;

    CommandResultCallback(SingleResultCallback<T> callback, Decoder<T> decoder, long requestId, ServerAddress serverAddress) {
        super(new BsonDocumentCodec(), requestId, serverAddress);
        this.callback = callback;
        this.decoder = decoder;
    }

    @Override
    protected void callCallback(BsonDocument response, Throwable t) {
        if (t != null) {
            this.callback.onResult(null, t);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Command execution completed with status " + ProtocolHelper.isCommandOk(response));
            }
            if (!ProtocolHelper.isCommandOk(response)) {
                this.callback.onResult(null, ProtocolHelper.getCommandFailureException(response, this.getServerAddress()));
            } else {
                try {
                    this.callback.onResult(this.decoder.decode(new BsonDocumentReader(response), DecoderContext.builder().build()), null);
                }
                catch (Throwable t1) {
                    this.callback.onResult(null, t1);
                }
            }
        }
    }
}

