/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.binding;

import java.util.function.BiConsumer;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterType;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AbstractReferenceCounted;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ReferenceCounted;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.com.mongodb.session.ClientSession;

public final class TransactionContext<C extends ReferenceCounted>
extends AbstractReferenceCounted {
    private final ClusterType clusterType;
    private C pinnedConnection;

    public TransactionContext(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    @Nullable
    public C getPinnedConnection() {
        return this.pinnedConnection;
    }

    public void pinConnection(C connection, BiConsumer<C, Connection.PinningMode> markAsPinnedOperation) {
        this.pinnedConnection = connection.retain();
        markAsPinnedOperation.accept(connection, Connection.PinningMode.TRANSACTION);
    }

    public boolean isConnectionPinningRequired() {
        return this.clusterType == ClusterType.LOAD_BALANCED;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0 && this.pinnedConnection != null) {
            this.pinnedConnection.release();
        }
        return count;
    }

    public static <C extends TransactionContext<? extends ReferenceCounted>> C get(ClientSession session) {
        return (C)((TransactionContext)session.getTransactionContext());
    }
}

