/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.binding;

import org.apache.flink.mongodb.shaded.com.mongodb.ReadConcern;
import org.apache.flink.mongodb.shaded.com.mongodb.ReadPreference;
import org.apache.flink.mongodb.shaded.com.mongodb.RequestContext;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerApi;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ClusterConnectionMode;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.ServerDescription;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.AbstractReferenceCounted;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ConnectionSource;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.binding.ReadWriteBinding;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Cluster;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Connection;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.Server;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.ServerTuple;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.selector.ReadPreferenceServerSelector;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.selector.ServerAddressSelector;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.selector.WritableServerSelector;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.session.SessionContext;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

public class ClusterBinding
extends AbstractReferenceCounted
implements ClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    @Nullable
    private final ServerApi serverApi;
    private final RequestContext requestContext;

    public ClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, @Nullable ServerApi serverApi, RequestContext requestContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public ReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public SessionContext getSessionContext() {
        return new ReadConcernAwareNoOpSessionContext(this.readConcern);
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ReadPreferenceServerSelector(this.readPreference)), this.readPreference);
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            return this.getReadConnectionSource();
        }
        ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
        ServerTuple serverTuple = this.cluster.selectServer(readPreferenceWithFallbackServerSelector);
        return new ClusterBindingConnectionSource(serverTuple, readPreferenceWithFallbackServerSelector.getAppliedReadPreference());
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new WritableServerSelector()), this.readPreference);
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ServerAddressSelector(serverAddress)), this.readPreference);
    }

    private final class ClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private ClusterBindingConnectionSource(ServerTuple serverTuple, ReadPreference appliedReadPreference) {
            this.server = serverTuple.getServer();
            this.serverDescription = serverTuple.getServerDescription();
            this.appliedReadPreference = appliedReadPreference;
            ClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return new ReadConcernAwareNoOpSessionContext(ClusterBinding.this.readConcern);
        }

        @Override
        public ServerApi getServerApi() {
            return ClusterBinding.this.serverApi;
        }

        @Override
        public RequestContext getRequestContext() {
            return ClusterBinding.this.requestContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public Connection getConnection() {
            return this.server.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            ClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            ClusterBinding.this.release();
            return count;
        }
    }
}

