/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.internal.async.function;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Immutable;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.NotThreadSafe;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.async.SingleResultCallback;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

@NotThreadSafe
public final class LoopState {
    private int iteration = 0;
    private boolean lastIteration;
    @Nullable
    private Map<AttachmentKey<?>, AttachmentValueContainer> attachments;

    boolean advance() {
        if (this.lastIteration) {
            return false;
        }
        ++this.iteration;
        this.removeAutoRemovableAttachments();
        return true;
    }

    public boolean isFirstIteration() {
        return this.iteration == 0;
    }

    boolean isLastIteration() {
        return this.lastIteration;
    }

    public int iteration() {
        return this.iteration;
    }

    public boolean breakAndCompleteIf(Supplier<Boolean> predicate, SingleResultCallback<?> callback) {
        Assertions.assertFalse(this.lastIteration);
        try {
            this.lastIteration = predicate.get();
        }
        catch (Throwable t) {
            callback.onResult(null, t);
            return true;
        }
        if (this.lastIteration) {
            callback.onResult(null, null);
            return true;
        }
        return false;
    }

    void markAsLastIteration() {
        Assertions.assertFalse(this.lastIteration);
        this.lastIteration = true;
    }

    public <V> LoopState attach(AttachmentKey<V> key, V value, boolean autoRemove) {
        this.attachments().put(Assertions.assertNotNull(key), new AttachmentValueContainer(Assertions.assertNotNull(value), autoRemove));
        return this;
    }

    public <V> Optional<V> attachment(AttachmentKey<V> key) {
        AttachmentValueContainer valueContainer = this.attachments().get(Assertions.assertNotNull(key));
        Object value = valueContainer == null ? null : valueContainer.value();
        return Optional.ofNullable(value);
    }

    private Map<AttachmentKey<?>, AttachmentValueContainer> attachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap();
        }
        return this.attachments;
    }

    private void removeAutoRemovableAttachments() {
        if (this.attachments == null) {
            return;
        }
        this.attachments.entrySet().removeIf(entry -> ((AttachmentValueContainer)entry.getValue()).autoRemove());
    }

    public String toString() {
        return "LoopState{iteration=" + this.iteration + ", attachments=" + this.attachments + '}';
    }

    @Immutable
    public static interface AttachmentKey<V> {
    }

    private static final class AttachmentValueContainer {
        @Nullable
        private final Object value;
        private final boolean autoRemove;

        AttachmentValueContainer(Object value, boolean autoRemove) {
            this.value = value;
            this.autoRemove = autoRemove;
        }

        @Nullable
        Object value() {
            return this.value;
        }

        boolean autoRemove() {
            return this.autoRemove;
        }

        public String toString() {
            return "AttachmentValueContainer{value=" + this.value + ", autoRemove=" + this.autoRemove + '}';
        }
    }
}

