/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.connection;

import org.apache.flink.mongodb.shaded.com.mongodb.annotations.ThreadSafe;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;
import org.apache.flink.mongodb.shaded.org.bson.BsonObjectId;
import org.apache.flink.mongodb.shaded.org.bson.types.ObjectId;

@ThreadSafe
public final class TopologyVersion {
    private final ObjectId processId;
    private final long counter;

    public TopologyVersion(BsonDocument topologyVersionDocument) {
        this.processId = topologyVersionDocument.getObjectId("processId").getValue();
        this.counter = topologyVersionDocument.getInt64("counter").getValue();
    }

    public TopologyVersion(ObjectId processId, long counter) {
        this.processId = processId;
        this.counter = counter;
    }

    public ObjectId getProcessId() {
        return this.processId;
    }

    public long getCounter() {
        return this.counter;
    }

    public BsonDocument asDocument() {
        return new BsonDocument("processId", new BsonObjectId(this.processId)).append("counter", new BsonInt64(this.counter));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyVersion that = (TopologyVersion)o;
        if (this.counter != that.counter) {
            return false;
        }
        return this.processId.equals(that.processId);
    }

    public int hashCode() {
        int result = this.processId.hashCode();
        result = 31 * result + (int)(this.counter ^ this.counter >>> 32);
        return result;
    }

    public String toString() {
        return "TopologyVersion{processId=" + this.processId + ", counter=" + this.counter + '}';
    }
}

