/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.connection;

import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoClientException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.UnixServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.BufferProvider;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.SocketSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.SslSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.Stream;
import org.apache.flink.mongodb.shaded.com.mongodb.connection.StreamFactory;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.PowerOfTwoBufferPool;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.SocketStream;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.connection.UnixSocketChannelStream;

public class SocketStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider = PowerOfTwoBufferPool.DEFAULT;

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings, SocketFactory socketFactory) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = socketFactory;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream;
        if (serverAddress instanceof UnixServerAddress) {
            if (this.sslSettings.isEnabled()) {
                throw new MongoClientException("Socket based connections do not support ssl");
            }
            stream = new UnixSocketChannelStream((UnixServerAddress)serverAddress, this.settings, this.sslSettings, this.bufferProvider);
        } else {
            stream = this.socketFactory != null ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.socketFactory, this.bufferProvider) : (this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider));
        }
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return this.sslSettings.getContext() == null ? SSLContext.getDefault() : this.sslSettings.getContext();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

