/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.geojson.codecs;

import org.apache.flink.mongodb.shaded.com.mongodb.client.model.geojson.Geometry;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.geojson.codecs.GeometryEncoderHelper;
import org.apache.flink.mongodb.shaded.org.bson.BsonReader;
import org.apache.flink.mongodb.shaded.org.bson.BsonWriter;
import org.apache.flink.mongodb.shaded.org.bson.codecs.Codec;
import org.apache.flink.mongodb.shaded.org.bson.codecs.DecoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.EncoderContext;
import org.apache.flink.mongodb.shaded.org.bson.codecs.configuration.CodecRegistry;

abstract class AbstractGeometryCodec<T extends Geometry>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> encoderClass;

    AbstractGeometryCodec(CodecRegistry registry, Class<T> encoderClass) {
        this.registry = registry;
        this.encoderClass = encoderClass;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        GeometryEncoderHelper.encodeGeometry(writer, value, encoderContext, this.registry);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return GeometryDecoderHelper.decodeGeometry(reader, this.getEncoderClass());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }
}

